require('dotenv').config()
const {
	router,
	transporter,
	smtpUser,
	smtpHost,
	siteUrl,
	siteHost
}=require('../shared.js')

router.post('/api/send-pasword-change-mail',(req,res) => {
	
let {username,to}=req.body

const subject="Your password just changed"
const text= `hello, your swiftdatas password has just been changed`
const html = `<div style='margin: 20px auto; text-align:center'><p>Hello ${username}, your <b><a style='text-decoration:none; color:rgba(59,130,246,1)' href='${siteUrl}/login'>${siteHost}</a></b> password has just been changed </p></div>`

async function sendPasswordChangeMail(){
	
  let mailOptions = {
    from: `"${siteHost}" <${smtpUser}>`,
    to: to,
    subject: subject,
    text: text,
    html: html,
  };

  try {
    let info = await transporter.sendMail(mailOptions);
    console.log('Message sent: %s', info.messageId);
    //console.log(info)
    res.send(info)
  } catch (error) {
  	res.send(error)
    console.error('Error sending email:', error);
  }
}

sendPasswordChangeMail()
})

router.post('/api/send-resetCode-mail',(req,res) => {
	let resetCode=req.body.resetCode
	
const to=req.body.to;
const subject="Password Reset"
const text= `your code is ${resetCode}`
const html = `<div style='margin: 20px auto; text-align:center'><p>Here's your <b><a style='text-decoration:none; color:rgba(59,130,246,1)' href='${siteUrl}/login'>${siteHost} </a></b> password reset code: </p><div style='background:rgba(59,130,246,0.9); display:inline ; padding:5px; border-radius:3px; color:white; font-weight:bolder ; font-size:24px ; '>${resetCode}</div></div>`

async function sendResetCode(){
//trnsport

  let mailOptions = {
    from: `"${siteHost}" <${smtpUser}>`,
    to: to,
    subject: subject,
    text: text,
    html: html,
  };

  try {
    let info = await transporter.sendMail(mailOptions);
    console.log('Message sent: %s', info.messageId);
    //console.log(info)
    res.send(info)
  } catch (error) {
  	res.send(error)
    console.error('Error sending email:', error);
  }
}

sendResetCode()
})


module.exports=router