require('dotenv').config()
const {
	db,
	router,
	generateUniqueId,
	extApiUrl,
	extApiKey,
	axios,
	strowalletPK,
	strowalletEnv
}=require('../shared.js')

router.post('/api/extApi/exam',async (req,res)=>{
  
 const hostSql="SELECT * FROM `services_api_keys` WHERE `usage` ='exam'"
  db.query(hostSql,(errH,dataH)=>{
    if(errH){
      console.log(errH)
      return
    }
    const siteHost=dataH[0].site_host
    const siteApiKey=dataH[0].api_key
  
	let sql="SELECT * FROM `purchases`"
let takenIds=[];
let newRefId;
	db.query(sql,(err,data3)=>{
		if(err){
			res.send(err)
			console.log(err)
			return
		}
			
data3.forEach(item => {
			takenIds.push(item.reference)
		})

newRefId=generateUniqueId(30,takenIds)

const values=[
 req.body.amount,
 req.body.id
]

const {
  id,
 quantity,
 profit,
 amount,
 exam
}=req.body

const data = {
 quantity:1,
 exam_name:exam
}

const config = {
  method: 'post',
maxBodyLength: Infinity,
  url: `${siteHost}/api/epin/`,
  headers: { 
    'Authorization': `Token ${siteApiKey}`, 
    'Content-Type': 'application/json'
  },
  data : data
};

let sql ="SELECT * FROM `users` WHERE `id` =?"
db.query(sql,[id],(err1,data1)=>{
	if(err1){
	console.log(err1)
	return;
}
	
	var oldBal=data1[0].balance
	var newBal=oldBal - req.body.amount

if(oldBal>=req.body.amount){
axios(config)
 .then(response=> { 
 console.log(response.data); 
 res.json(response.data)
 if(response.data.Status && response.data.Status=="successful"){
 let sql4="INSERT INTO `purchases`(`user_id`, `status`, `tran_type`, `item_id`, `new_balance`, `service_type`, `truth_res`, `description`, `old_balance`, `reference`, `amount`,`username`,`profit`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
 
 let values3=[
 	req.body.id,
 	"success",
 	"Debit",
 	0,
 	newBal,
 	"Epin",
 	`you have successfully bought ${exam} exam pin for &#8358;${amount}. </br> Pin : ${response.data.pins[0]}`,
 	`${exam} &#8358;${amount} epin`,
 	oldBal,
 	newRefId,
 	amount,
 	data1[0].username,
  profit
 	]
 	db.query(sql4,values3,(err4,data5)=>{
 		if(err4){
 		console.log(err4)
 		return;
 	}
 		
 		if(data5.affectedRows>0){
 	let sql5="UPDATE `users` SET `balance` =? WHERE `id`=? ";
	db.query(sql5,[newBal,req.body.id],(err6,data6)=>{
	if(err6){
		console.log(err6)
		return
	}	
	console.log(data6)	
})}
})
}
})
 .catch(error => { 
 	let errorMessage=error.response;
 	if(error.response.data) {
 errorMessage=error.response.data.error[0]
 	}
   console.log(error);
 	//console.log(data)
 res.json({agentError:errorMessage})
 	console.log({agentError:errorMessage})
   });
return;
}
res.send("insufficient balance")
console.log("insufficient balance")
}) 
})
})
})

router.post('/api/extApi/electricity',async (req,res)=>{

const {
  disco,
  meterNumber,
  meterAddress,
  meterType,
  id,
  phone,
  amount,
  meterOwner
}=req.body

const profit= amount/100*0.5

/*console.log(amount)
console.log(phone)
console.log(disco)*/

 const hostSql="SELECT * FROM `services_api_keys` WHERE `usage` ='electricity'"
  db.query(hostSql,(errH,dataH)=>{
    if(errH){
      console.log(errH)
      return
    }
    const siteHost=dataH[0].site_host
    const siteApiKey=dataH[0].api_key
  
	let sql="SELECT * FROM `purchases`"
let takenIds=[];
let newRefId;
	db.query(sql,(err,data3)=>{
		if(err){
			res.send(err)
			console.log(err)
			return;
	}
		
data3.forEach(item => {
			takenIds.push(item.reference)
		})

newRefId=generateUniqueId(30,takenIds)

const options = {
  method: 'POST',
  url: `${siteHost}/api/electricity/request/`,
  headers: {accept: 'application/json', 'content-type': 'application/json'},
  data: {
    public_key: siteApiKey,
    amount: amount,
    phone: phone,
    service_name: disco,
    meter_number: meterNumber,
    meter_type: meterType
  }
};
//45135745250

let sql ="SELECT * FROM `users` WHERE `id` =?"
db.query(sql,[id],(err1,data1)=>{
	if(err1){
	console.log(err1)
	res.send(err1)
	return;
}
	
	var oldBal=data1[0].balance
	var newBal=oldBal - req.body.amount

if(oldBal>=amount){
axios.request(options)
 .then(response=> { 
  console.log(response.data);
  
  if(response.data.message=='Insufficient  Balance !!'){
    res.json({agentError: response.data.message})
    return;
  }
  
 res.json(response.data)
 
 if(response.data.success && response.data.success==true){
 let sql4="INSERT INTO `purchases`(`user_id`, `status`, `tran_type`, `item_id`, `new_balance`, `service_type`, `truth_res`, `description`, `old_balance`, `reference`, `amount`, `profit`,`username`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
 
 let values3=[
 	id,
 	"success",
 	"debit",
 	meterNumber,
 	newBal,
 	"Electricity",
 	`you have successfully bought &#8358;${amount} ${disco} meter token for ${meterNumber} <br/>Meter owner : ${meterOwner} <br/>Meter Address ${meterAddress} <br/>Token : ${response.data.response.Token}`,
 	`<b>${disco}</b> &#8358;${amount} for ${meterNumber}`,
 	oldBal,
 	newRefId,
 	amount,
 	profit,
 	data1[0].username
 	]
 	db.query(sql4,values3,(err4,data5)=>{
 	if(err4){
 		console.log(err4)
 		return;
 	}
 		
 		if(data5.affectedRows>0){
 	let sql5="UPDATE `users` SET `balance` =? WHERE `id`=? ";
	db.query(sql5,[newBal,req.body.id],(err6,data6)=>{
	if(err6){
		console.log(err6)
		return;
	}	
		console.log(data6)	
 	})}
 	})
 }
 
 })
 .catch(error => { 
   //console.log(error);
 	const errorMessage = error.response.data.error;
 	res.json({agentError:errorMessage})
 	console.log({agentError:errorMessage})
 	console.log(error.response.data)
   });			
return;
}
res.send("insufficient balance")
console.log("insufficient balance")
}) 

}) 
})
})
 
router.post('/api/extApi/send-sms',async (req,res)=>{

const {
    senderName,
    phone,
    message,
    id,
    total,
    gain
  }=req.body

//https://www.gladtidingsdata.com/api/sendsms/

const phoneArr=phone.split(',')

const feeSql="SELECT * FROM `pricing` WHERE `network`='bulk sms'"
	
 db.query(feeSql,(feeErr,feeData)=>{
  if(feeErr){
    console.log(feeErr)
    return
  }
 let feeType=feeData[0].type 
 let finalFee=parseInt(parseFloat(feeData[0].percent))
 
//0.67%
 const hostSql="SELECT * FROM `services_api_keys` WHERE `usage` ='bulk sms'"
  db.query(hostSql,(errH,dataH)=>{
    if(errH){
      console.log(errH)
      return
    }
    const siteHost=dataH[0].site_host
    const siteApiKey=dataH[0].api_key
  
	let sql="SELECT * FROM `purchases`"
let takenIds=[];
let newRefId;
	db.query(sql,(err,data3)=>{
		if(err){
			res.send(err)
			console.log(err)
			return;
	}
		
data3.forEach(item => {
			takenIds.push(item.reference)
		})

newRefId=generateUniqueId(30,takenIds)

const values=[
 req.body.plan_id ,
 req.body.phone,
 req.body.amount,
 req.body.id,
 req.body.profit
 
]

/*const options = {
  method: 'POST',
  url: `${siteHost}/api/bulk-sms/?public_key=${siteApiKey}&sender_id=${senderName}&message=${message}&phone=${phone}`,
  headers: {accept: 'application/json'}
};*/

const options = {
  method: 'POST',
  url: `${siteHost}/api/sendsms/`,
  headers: {
    accept: 'application/json',
    Authorization:`Token ${siteApiKey}`
  },
  data:{
   recetipient: phone,
   message,
   sender: senderName,
   DND: true
  }
};

/*let senderNameSql ="SELECT * FROM `bulk_sms_usernames` WHERE `user_id` =? AND `name` =?"

db.query(senderNameSql,[id,senderName],(errName,dataName)=>{
  
  if(errName){
    console.log(errName)
    return
  }
  
  if(dataName.length ==0){
    res.json({
      "success":false,
      "message":"Sender Name Not Found"
    })
    return
  }*/
  

let sql ="SELECT * FROM `users` WHERE `id` =?"
db.query(sql,[id],(err1,data1)=>{
	if(err1){
	console.log(err1)
	res.send(err1)
	return;
}
	
	var oldBal=data1[0].balance
	var newBal=oldBal - total

if(oldBal>=total){
axios.request(options)
 .then(response=> { 
  console.log(response.data);
  
  if(response.data.message.toLowerCase().includes('balance')){
    res.json({agentError: response.data.message})
    return;
  }
  
  res.json({
    success:true,
    message:response.data.message
  })
  
 //res.json(response.data)
 //response.data.success && response.data.success==true
 if(response.data.message.includes('Message succesfully sent')){
 let sql4="INSERT INTO `purchases`(`user_id`, `status`, `tran_type`, `item_id`, `new_balance`, `service_type`, `truth_res`, `description`, `old_balance`, `reference`, `amount`, `profit`,`username`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
 
 let values3=[
 	id,
 	"success",
 	"debit",
 	0,
 	newBal,
 	"Bulk sms",
 	`you have successfully sent sms at &#8358;${total} to ${phone.length >= 2 ? phone.slice(0,11)+`...X${phoneArr.length}`: phone}<br/> Message: <br/> ${message.length >= 150 ? message.slice(0,150)+'...' : message} `,
 	`<b>sent sms</b> at &#8358;${total} for ${phone.length >= 14 ? phone.slice(0,14)+'...' : phone}`,
 	oldBal,
 	newRefId,
 	total,
 	gain,
 	data1[0].username
 	]
 	db.query(sql4,values3,(err4,data5)=>{
 	if(err4){
 		console.log(err4)
 		return;
 	}
 		
 		if(data5.affectedRows>0){
 	let sql5="UPDATE `users` SET `balance` =? WHERE `id`=? ";
	db.query(sql5,[newBal,req.body.id],(err6,data6)=>{
	if(err6){
		console.log(err6)
		return;
	}	
		console.log(data6)	
 	})}
 	})
 }
 
 })
 .catch(error => { 
  console.log(error)
 	const errorMessage = error.response ? error.response.data.error : error;
 	//res.json({agentError:"error"})
 	console.log({agentError:errorMessage})
 	res.json({agentError:errorMessage})
 	//res.send("error occurred")
   });			
return;
}
res.send("insufficient balance")
console.log("insufficient balance")
}) 


  
//})

}) 
})

})
})

router.post('/api/extApi/gen-airtime-pins',(req,res)=>{
	const {
		amount,
		network,
		quantity,
		user_id,
		total,
		gains
	}=req.body

const apiSql="SELECT * FROM `services_api_keys` WHERE `usage` ='airtime pins'"
		db.query(apiSql,(errSql,dataSql)=>{
		  if(errSql){
		    console.log(errSql)
		    return;
		  }
	 //const strApiKeys=dataSql.filter(item => item.name=='strowallet')[0]
	 const apiKey=dataSql[0].api_key
	 const siteHost=dataSql[0].site_host
		  
if(!amount || !network || !quantity || !user_id || !total){
	res.send('missing important body data')
	console.log('missing important body data')
	return;
}

const options2 = {
  method: 'POST',
  url: `${siteHost}/api/buy_epin/?public_key=${apiKey}&card_network=${network}&value=${amount}&quantity=${quantity}&mode=${strowalletEnv}`,
  headers: {accept: 'application/json'}
};
//console.log(options2.url)
//&mode=sandbox

let sql="SELECT * FROM `purchases`"
let takenIds=[];
let newRefId;
	db.query(sql,(err,data3)=>{
		if(err){
			res.send(err)
			console.log(err)
			return;
	}
		
data3.forEach(item => {
			takenIds.push(item.reference)
		})

newRefId=generateUniqueId(30,takenIds)

let sql ="SELECT * FROM `users` WHERE `id` =?"
db.query(sql,[user_id],(err1,data1)=>{
	if(err1){
	console.log(err1)
	res.send(err1)
	return;
}
	
	var oldBal=data1[0].balance
	var newBal=oldBal - total

if(oldBal>=total){

axios
  .request(options2)
  .then(function (response) {
    console.log(response.data);
    
    const currentTime=new Date().toLocaleString('en-US', {
    year: 'numeric',
    month: '2-digit',
    day: '2-digit',
    hour: '2-digit',
    minute: '2-digit',
    second: '2-digit'
})
   let resObj=response.data
    resObj.myDate=currentTime
    
    res.send(resObj)
   
  if(response.data.status=='success'){
  	
  const sql3="INSERT INTO `purchases`(`user_id`, `status`, `tran_type`, `item_id`, `new_balance`, `service_type`, `truth_res`, `description`, `old_balance`, `reference`, `amount`, `profit`,`username`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
  	
  const values3=[
  	user_id,
  	'success',
  	'Debit',
  	0,
  	newBal,
  	'Airtime Pins',
  	`you have successfully generated 10 ${network} card pins for &#8358;${total}`,
  	`10 ${network} card pins generated`,
  	oldBal,
  	newRefId,
  	total,
  	gains,
  	data1[0].username
  	]	
  	
  db.query(sql3,values3,(err3,data3)=>{
  	if(err3){
  		console.log(err3)
  		return;
  	}
  	
  	//console.log(data3)
  	
  	if(data3.affectedRows >0){
  		//console.log('purchace inserted')
  
    const sql4="UPDATE `users` SET `balance` =? WHERE `id`=? ";
  	db.query(sql4,[newBal,user_id],(err4,data4)=>{
  		if(err4){
  			console.log(err4)
  			return;
  		}
  		
  		//console.log(data4)
  		
  		if(data4.affectedRows >0){
  			//console.log('balance updated')
  		}
  	})	
  		
  		
  	}
  })	
  	
  	
 response.data.data.cards.map(c => {
  console.log('card pin ='+c.pin +'\n'+ 'card serial='+c.serial +'\n' )
  		
  const sql="INSERT INTO `airtime_pins` (`user_id`,`pin`,`serial`,`network`,`amount`) VALUES(?,?,?,?,?)"
  const values=[
  			user_id,
  			c.pin,
  			c.serial,
  			network,
  			amount
  			]
  		
  db.query(sql,values,(err,data)=>{
  	if(err){
  		 console.log(err)
  		 return;
  	}
  			
  			//console.log(data)
    if(data.affectedRows >0){
  		//console.log('pin inserted into db')
  				//res.send('pins inserted')
  			}
  		})
  		
  	})
  	
  }
    
  })
  .catch(function (error) {
    if(error.response){
     /*console.error(error.response.data);
     console.error(error.response.data.message);*/
     
    res.json({
    	agentError: error.response.data.message
    }) 
    
    return
  } 
    
    //console.error(error.message);
    res.send(error.message)
  });

return;
}

res.send("insufficient db usr balance")
console.log("insufficient db usr balance")

})
})
})  
})

router.post('/api/extApi/data',async (req,res)=>{
  
 const hostSql="SELECT * FROM `services_api_keys` WHERE `usage` ='data'"
  db.query(hostSql,(errH,dataH)=>{
    if(errH){
      console.log(errH)
      return
    }
    const siteHost=dataH[0].site_host
    const siteApiKey=dataH[0].api_key
  

	let sql="SELECT * FROM `purchases`"
let takenIds=[];
let newRefId;
	db.query(sql,(err,data3)=>{
		if(err){
			res.send(err)
			console.log(err)
			return;
	}
		
data3.forEach(item => {
			takenIds.push(item.reference)
		})

newRefId=generateUniqueId(30,takenIds)

const values=[
 req.body.plan_id ,
 req.body.phone,
 req.body.amount,
 req.body.id,
 req.body.profit
 
]

//console.log('profit',req.body.profit)

const data = {
	"network":req.body.network_id,
"mobile_number": req.body.phone,
"plan": req.body.plan_id,
"Ported_number":req.body.ported
};

let config = {
  method: 'post',
maxBodyLength: Infinity,
  url: `${siteHost}/api/data/`,
  headers: { 
    'Authorization': `Token ${siteApiKey}`,
    'Content-Type': 'application/json'
  },
  data : data
};

let sql ="SELECT * FROM `users` WHERE `id` =?"
db.query(sql,values[3],(err1,data1)=>{
	if(err1){
	console.log(err1)
	res.send(err1)
	return;
}
	
	var oldBal=data1[0].balance
	var newBal=oldBal - req.body.amount

if(oldBal>=req.body.amount){
axios(config)
 .then(response=> { 
  console.log(response.data); 
 res.json(response.data)
 if(response.data.Status && response.data.Status=="successful"){
 let sql4="INSERT INTO `purchases`(`user_id`, `status`, `tran_type`, `item_id`, `new_balance`, `service_type`, `truth_res`, `description`, `old_balance`, `reference`, `amount`, `profit`,`username`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
 
 let values3=[
 	req.body.id,
 	"success",
 	"debit",
 	req.body.phone,
 	newBal,
 	"Data Topup",
 	`you have successfully bought &#8358;${req.body.amount} ${req.body.network.replace("_PLAN","")} ${req.body.name} for ${req.body.phone}`,
 	`${req.body.network.replace("_PLAN","")} <b>${req.body.plan_type}</b> ${req.body.name} to ${req.body.phone}`,
 	oldBal,
 	newRefId,
 	req.body.amount,
 	req.body.profit,
 	data1[0].username
 	]
 	db.query(sql4,values3,(err4,data5)=>{
 	if(err4){
 		console.log(err4)
 		return;
 	}
 		
 		if(data5.affectedRows>0){
 	let sql5="UPDATE `users` SET `balance` =? WHERE `id`=? ";
	db.query(sql5,[newBal,req.body.id],(err6,data6)=>{
	if(err6){
		console.log(err6)
		return;
	}	
		console.log(data6)	
 	})}
 	})
 }
 
 })
 .catch(error => { 
 	const errorMessage = error.response.data.error ? error.response.data.error : error.response;
 	
 	res.json({agentError:errorMessage})
 	
 });			
return;
}
res.send("insufficient balance")
console.log("insufficient balance")
}) 

}) 
})
})

router.post('/api/extApi/topup',async (req,res)=>{
  
 const hostSql="SELECT * FROM `services_api_keys` WHERE `usage` ='airtime'"
  db.query(hostSql,(errH,dataH)=>{
    if(errH){
      console.log(errH)
      return
    }
    const siteHost=dataH[0].site_host
    const siteApiKey=dataH[0].api_key
  
	let sql="SELECT * FROM `purchases`"
let takenIds=[];
let newRefId;
	db.query(sql,(err,data3)=>{
		if(err){
			res.send(err)
			console.log(err)
			return
		}
			
data3.forEach(item => {
			takenIds.push(item.reference)
		})

newRefId=generateUniqueId(30,takenIds)

const values=[
 req.body.network_id ,
 req.body.phone,
 req.body.amount,
 req.body.id
]

const {network_id,amount}=req.body
let profit=0;

if(network_id==1){
 profit= amount - amount/100*98 
}
if(network_id==2){
 profit= amount - amount/100*97 
}
if(network_id==3){
 profit= amount - amount/100*97.5
}
if(network_id==4){
 profit= amount - amount/100*98
}

const data = {
	"network": req.body.network_id,
	"amount": req.body.amount,
	"mobile_number": req.body.phone,
	"Ported_number": req.body.isPorted,
	"airtime_type": "VTU"
}

const config = {
  method: 'post',
maxBodyLength: Infinity,
  url: `${siteHost}/api/topup/`,
  headers: { 
    'Authorization': `Token ${siteApiKey}`, 
    'Content-Type': 'application/json'
  },
  data : data
};

let sql ="SELECT * FROM `users` WHERE `id` =?"
db.query(sql,values[3],(err1,data1)=>{
	if(err1){
	console.log(err1)
	return;
}
	
	var oldBal=data1[0].balance
	var newBal=oldBal - req.body.amount

if(oldBal>=req.body.amount){
axios(config)
 .then(response=> { 
 //console.log(response.data); 
 res.json(response.data)
 if(response.data.Status && response.data.Status=="successful"){
 let sql4="INSERT INTO `purchases`(`user_id`, `status`, `tran_type`, `item_id`, `new_balance`, `service_type`, `truth_res`, `description`, `old_balance`, `reference`, `amount`,`username`,`profit`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
 
 let values3=[
 	req.body.id,
 	"success",
 	"Debit",
 	req.body.phone,
 	newBal,
 	"Airtime VTU",
 	`you have successfully bought &#8358;${req.body.amount} ${req.body.network} airtime for ${req.body.phone} `,
 	`${req.body.network} &#8358;${req.body.amount} to ${req.body.phone}`,
 	oldBal,
 	newRefId,
 	req.body.amount,
 	data1[0].username,
  profit
 	]
 	db.query(sql4,values3,(err4,data5)=>{
 		if(err4){
 		console.log(err4)
 		return;
 	}
 		
 		if(data5.affectedRows>0){
 	let sql5="UPDATE `users` SET `balance` =? WHERE `id`=? ";
	db.query(sql5,[newBal,req.body.id],(err6,data6)=>{
	if(err6){
		console.log(err6)
		return
	}	
	console.log(data6)	
})}
})
}
})
 .catch(error => { 
 	const errorMessage = error.response.data.error ? error.response.data.error : error.response;
 	
 res.json({agentError:errorMessage})
 	
  });
return;
}
res.send("insufficient balance")
console.log("insufficient balance")
}) 
})
})
})

router.post('/api/extApi/cabletv', (req,res)=>{
 
 const {
 	cableId, 
 	planId, 
 	iuc,
 	id, 
 	planPrice, 
 	profit, 
 	cableTvName,
 	cableTvPackage
 }=req.body;

//console.log('profit',profit)

 const hostSql="SELECT * FROM `services_api_keys` WHERE `usage` ='cable sub'"
  db.query(hostSql,(errH,dataH)=>{
    if(errH){
      console.log(errH)
      return
    }
    const siteHost=dataH[0].site_host
    const siteApiKey=dataH[0].api_key

 const data = {
    cablename: cableId,
    cableplan: planId,
    smart_card_number: iuc
  };

 const config = {
    method: 'post',
    maxBodyLength: Infinity,
    url: `${siteHost}/api/cablesub/`,
    headers: { 
      'Authorization': `Token ${siteApiKey}`, 
      'Content-Type': 'application/json'
    },
    data: data
  };

let sql="SELECT * FROM `purchases`"
let takenIds=[];
let newRefId;
	db.query(sql,(err,data3)=>{
		if(err){
			res.send(err)
			console.log(err)
			return;
	}
		
 data3.forEach(item =>{
	takenIds.push(item.reference) })

 newRefId=generateUniqueId(30,takenIds)

 let sql2 ="SELECT * FROM `users` WHERE `id` =?"
 db.query(sql2,[id],(err2,data2)=>{
 	if(err2){
 		console.log(err2)
 		res.send(err2)
 		return
 	}
 	
  if(!data2){
 		console.log('no user found')
 	  res.send('no user found')
 		return;	
 	}
 	
 	const oldBal=data2[0].balance;
 	const newBal= (parseInt(oldBal) - planPrice)
 	
 	if(oldBal < planPrice){
 		console.log('insufficient balance')
  	res.send('insufficient balance')
 		return;
 	}
 	
axios(config)
 .then(response => {
   res.json(response.data);
   
  if(response.data.Status && response.data.Status=="successful"){
   const sql3="INSERT INTO `purchases`(`user_id`, `status`, `tran_type`, `item_id`, `new_balance`, `service_type`, `truth_res`, `description`, `old_balance`, `reference`, `amount`, `profit`,`username`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
 
 const values3=[
 	req.body.id,
 	"success",
 	"Debit",
 	iuc,
 	newBal,
 	"Cable Sub",
 	`you have successfully paid ${cableTvName} ${cableTvPackage} for &#8358;${planPrice} to iuc: ${iuc}`,
 	`&#8358;${planPrice} ${cableTvName} ${cableTvPackage} for ${iuc}`,
 	oldBal,
 	newRefId,
  planPrice,
 	profit,
 	data2[0].username
 	]
 	
 	db.query(sql3,values3,(err3,data3)=>{
 	if(err3){
 		console.log(err3)
 		return;
 	}
 		
 	if(data3.affectedRows>0){
 	const sql4="UPDATE `users` SET `balance` =? WHERE `id`=? ";
	db.query(sql4,[newBal,id],(err4,data4)=>{
	if(err4){
		console.log(err4)
		return;
	}	
		//console.log(data4)	
		
		if(data4.affectedRows >0){
			console.log('cablesub bought and balance updated')
		}
 	})
 		
 	}
 	
 	})
 	
 } 
   
  })
 .catch(error => {
   //const errorMessage = error.response ? error.response.data.error : error;
   
   const errorMessage = error.response.data.error ? error.response.data.error : error.response;
   
   res.json({agentError:errorMessage})
  });

 })

})

})
});

module.exports=router