require('dotenv').config()
const {
	db,
	router,
	generateUniqueId,
	axios,
	monnifyApiKey,
	monnifySecretKey,
	strowalletPK,
	siteUrl,
	monnifyContractCode,
	BVN,
	NIN
}=require('../shared.js')

//console.log(`${siteUrl}/api/strowallet-webhook`)

async function genAccessToken() {
  try {
    // Fetch API keys from the database
    const apiSql = "SELECT * FROM `gateway_api_keys`";
    const dataSql = await new Promise((resolve, reject) => {
      db.query(apiSql, (errSql, result) => {
        if (errSql) return reject(errSql);
        resolve(result);
      });
    });

    const monnifyKeys = dataSql.find(item => item.name === 'monnify');
    if (!monnifyKeys) throw new Error('Monnify keys not found in the database');

    const base64MonnifyKey = Buffer.from(`${monnifyKeys.public_key}:${monnifyKeys.secret_key}`).toString('base64');

    // Make the Axios request
    const config = {
      method: 'post',
      maxBodyLength: Infinity,
      url: `https://api.monnify.com/api/v1/auth/login`,
      headers: {
        Authorization: `Basic ${base64MonnifyKey}`,
        'Content-Type': 'application/json',
      },
    };

    const res = await axios(config);

    if (res.data.responseMessage === 'success') {
      //console.log('Token generated successfully');
      return res.data.responseBody.accessToken;
    } else {
      throw new Error('Failed to generate token');
    }
  } catch (err) {
    console.error('Error generating token:', err.message);
    return 'err during token gen';
  }
}

router.post('/api/strowallet-va',(req,res)=>{

const {user_id}=req.body

const apiSql="SELECT * FROM `gateway_api_keys`"
		db.query(apiSql,(errSql,dataSql)=>{
		  if(errSql){
		    console.log(errSql)
		    return;
		  }
	 const strApiKey=dataSql.filter(item => item.name=='strowallet')[0]
		
//console.log('gen started')

const paga='https://strowallet.com/api/virtual-bank/paga',
bankly='https://strowallet.com/api/virtual-bank/bankly',
safehaven='https://strowallet.com/api/virtual-bank/safehaven',
amucha='https://strowallet.com/api/virtual-bank/amucha',
random='https://strowallet.com/api/virtual-bank/new-customer/'

function gen(url){
	
 const feeSql="SELECT * FROM `pricing` WHERE `network`='virtual_accounts'"
	
db.query(feeSql,(feeErr,feeData)=>{
  if(feeErr){
    console.log(feeErr)
    return
  }
 
 //let finalFee=3.5
 let finalFee=parseInt(feeData[0].percent)
	
const sql01="SELECT * FROM `users` WHERE `id` =?"	

db.query(sql01,[user_id],(err01,data01)=>{
	if(err01){
		console.log(err01)
		res.send(err01)
		return;
	}
	
  if(data01.length <1){
  	console.log('invalid user')
  	res.send('invalid user')
  	return;
  }
	
	const email=data01[0].email
	const phone=data01[0].phone
	const account_name=`${data01[0].first_name} ${data01[0].last_name}`
	
const options = {
  method: 'POST',
  url,
  headers: {accept: 'application/json', 'content-type': 'application/json'},
  data: {
    
    public_key: strApiKey.public_key,
    email,
    account_name,
    phone:String(phone),
    webhook_url: `${siteUrl}/api/strowallet-webhook`
  }
};

axios
  .request(options)
  .then(resp => {
   const respObj=resp.data
  
   //console.log(respObj)
  
  if(respObj.message=='Account Generated Successfully.'){
    const sql='INSERT INTO `virtual_accounts` (`account_reference`, `providers_account_referrence`, `account_number`,`account_name`,`bank_name`,`fees`,`user_id`) VALUES (?,?,?,?,?,?,?)'
  
  const values=[
  	'',
  	'',
  	respObj.account_number,
  	respObj.account_name,
  	respObj.bank_name,
  	finalFee,
  	user_id
  ]
  
  db.query(sql,values,(err,data)=>{
  	if(err){
  		console.log(err)
  		res.send(err)
  		return;
  	}
  	
  	//console.log(data)
  	
  	if(data.affectedRows > 0){
  		console.log('va inserted')
  		res.send('va inserted')
      return;
  	}
  	
  	console.log('va not inserted')
  	res.send('va not inserted')
  	return
  
  })  
  	return;
  }
  
  console.log('va gen failed')
  //res.send('va gen failed')
  
 })
  
  .catch(err => {
  	 //console.log(err.response ? err.response.data : err)
  	 
  	//res.send(err.response ? err.response.data : err)
  
  	 
  });


})

})
}
  
 const sql0 ="SELECT * FROM `virtual_accounts` WHERE `user_id` =?"	
db.query(sql0,[user_id],(err0,data0)=>{

	if(err0){
		console.log(err0)
		return
	}
	
 if(data0.length && data0.length >=1){
	console.log('user already has a va')
	res.send('user already has a va')
		return
	}
	
 gen(paga);
 //gen(bankly);
 
//res.send('done')

})
})
})

router.post('/api/strowallet-webhook',(req,res)=>{

const obj =req.body

const accountNumber =obj.accountNumber,
sourceBankName=obj.sourceBankName,
transactionAmount=obj.transactionAmount,
sessionId=obj.sessionId

const referralComm =transactionAmount/100*0.5 

if(obj.accountNumber){
  const feeSql="SELECT * FROM `pricing` WHERE `network`='virtual_accounts'"
	
 db.query(feeSql,(feeErr,feeData)=>{
  if(feeErr){
    console.log(feeErr)
    return
  }
 let feeType=feeData[0].type 
 let finalFee=parseInt(feeData[0].percent)
 //console.log(finalFee)

	const sql='SELECT * FROM `virtual_accounts` WHERE `account_number` = ?' 
  const values =[
	accountNumber
  ] 
	
	db.query(sql,values,(err,data)=>{
/*console.log(data.length)
console.log(data)*/

if(err){
	console.log(err)
	return
}

if(data.length < 1){
  console.log('no virtual account found')	
  res.send('no virtual account found')	
	return;
}

const vaDetails=data[0]

const sql2 ='SELECT * FROM `users` WHERE `id` = ?'

const values2 =[
	vaDetails.user_id
	]

db.query(sql2,values2,(err2,data2)=>{
	if(err2){
		console.log(err2)
		console.log('could not select user_id from users table')
		return
	}

if(data2.length == 0){
	console.log('could not select user_id from users table')
	return
}

//console.log(data2[0])

const userDetails	= data2[0]
const sql3 ='INSERT INTO `deposits`(`user_id`, `amount`, `service_type`, `old_balance`, `new_balance`, `status`, `fees`, `tran_type`, `ref`,`narration`,`username`) VALUES (?,?,?,?,?,?,?,?,?,?,?)'

/*const charge = (sourceBankName.includes('paga') ? 5 : 10);*/

/*const finalAmount =transactionAmount > charge ? (transactionAmount - charge) : 0;*/

//const charge = transactionAmount/100*3.5;

/*const charge = transactionAmount/100*finalFee;

const finalAmount =transactionAmount > charge ? parseInt(transactionAmount) - charge : 0;*/

let charge=finalFee;
//let finalAmount=0;

 if(feeType=='percentage'){
  charge = transactionAmount/100*finalFee;
}
/*else{
  charge =finalFee;
}*/

//console.log(finalFee)

const finalAmount =transactionAmount > charge ? parseInt(transactionAmount) - charge : 0;

const values3 =[
	userDetails.id,
	finalAmount,
	'Wallet Funding',
	userDetails.balance,
	parseInt(userDetails.balance)+parseInt(finalAmount),
	'success',
	charge,
	'Credit',
	sessionId,
	`&#8358;${transactionAmount} deposit through strowallet virtual account with &#8358;${charge} charge. ${accountNumber}`,
	userDetails.username
	]
	
	db.query(sql3,values3,(err3,data3)=>{
		if(err3){
			console.log(err3)
			console.log('deposit record not inserted')
			return
		}
		console.log(data3)
		//console.log('deposit record inserted')
		
	})
	
const sql4="UPDATE `users` SET `balance`=`balance`+? WHERE `id`=?"
const values4 =[
	finalAmount,
	userDetails.id
	]
	
	db.query(sql4,values4,(err4,data4)=>{
		if(err){
			console.log(err4)
			res.send(err4)
			console.log('err while updating balance')
			return
		}
	//console.log(data4)
		
 if(data4.affectedRows < 1){
 	console.log('balance was not updated')
 	res.send('balance was not updated')
 	return;
 }
 
 
	 console.log('balance was updated')
	 res.send('balance was updated')
	 
	const referrer=userDetails.referrer_username
	const sql6="UPDATE `users` SET `balance`=`balance`+?, `referral_comm`=`referral_comm`+? WHERE `username`=?"
	 	 	
	db.query(sql6,[referralComm,referralComm,referrer],(err6,data6)=>{
   if(err6){
			console.log(err6)
			return;
		}
		console.log(data6)
		
	 if(data6.affectedRows >0){
			console.log('strowallet paid referrer')
			return;
		}
	console.log('strowallet did not pay referrer')
 })
	 
	})

})

})
})	
}
else{
	
	
}
	
})


// Call the function
/*(async () => {
  const token = await genAccessToken();
  console.log('Generated Token:', token);
})();*/

router.post('/api/monnify-va', async(req,res)=>{
const {user_id} = req.body

console.log('monnify-va has been accessed')

const genToken =  await genAccessToken()

	//console.log(genToken)
	
	const apiSql="SELECT * FROM `gateway_api_keys`"
		db.query(apiSql,(errSql,dataSql)=>{
		  if(errSql){
		    console.log(errSql)
		    return;
		  }
	 const monnifyKeys=dataSql.filter(item => item.name=='monnify')[0]
		  
	 //console.log(dataSql)
	 
	
const sql0 ="SELECT * FROM `virtual_accounts` WHERE `user_id` =?"	
db.query(sql0,[user_id],(err0,data0)=>{
	//console.log(data0)
	//console.log('check va data')
	if(err0){
		console.log(err0)
		return
	}
	
	if(data0.length > 0){
	console.log('user already has a va')
	res.send('user already has a va')
		return
	}
  
  console.log('va - gen started because user has no va')

if(genToken.includes('err')){
	console.log(genToken)
	//res.send(genToken)
	console.log('token gen fail')
	return
}

	const Paga ="327",
	      Wema ='035',
	      Sterling ='232',
	      Access ='044',
	      FirstBank ='011',
	      SmartCash ='00803'
//const selectedBank= bank == 'Wema' ? Wema : Sterling
//const selectedBank = (bank =='Wema bank' && Wema) || (bank == 'Sterling bank' && Sterling) 

const sql4 = 'SELECT * FROM `users` WHERE `id`=? '
db.query(sql4,[user_id],(err4,data4)=>{
	if(err4){
		console.log(err4)
		return
	}
const userDetails = data4[0]

if(!userDetails){
	res.send('user not found')
	console.log('user not found')
	return
}

async function createVa(bank){
	await new Promise((resolve,reject)=>{
	
	const feeSql="SELECT * FROM `pricing` WHERE `network`='virtual_accounts'"
	
 db.query(feeSql,(feeErr,feeData)=>{
  if(feeErr){
    console.log(feeErr)
    return
  }
  
 let finalFee=parseInt(feeData[0].percent)
 console.log(finalFee)
		
 const sql5 ="SELECT * FROM `virtual_accounts` WHERE `user_id`=?"
db.query(sql5,[user_id],(err5,data5)=>{
	if(err5){
		console.log(err5)
		reject(err5)
		return;
	}
	
if(data5.length >= 2){
	console.log('VAs up to 2')
	reject('user already has 2 accounts')
	return;
 }
 
let takenIds=[];
let newRefId;
const sql3=`SELECT * FROM virtual_accounts `
db.query(sql3,(err3,data3)=>{
if(err3){
 //res.send(err3)
 console.log(err3)
 return;
}
data3.forEach(item => {
  takenIds.push(item.account_reference)
})
 newRefId= generateUniqueId(30,takenIds)
     
var config = {
  method: 'post',
maxBodyLength: Infinity,
  url: `https://api.monnify.com/api/v2/bank-transfer/reserved-accounts`,
  headers: { 
    Authorization: `Bearer ${genToken}`,
    'Content-Type': 'application/json'
  },
data:{ 
	"accountReference": newRefId,
  "accountName": userDetails.username,
  "currencyCode": "NGN",
  "contractCode": monnifyKeys.contract_code,
  "customerEmail": userDetails.email,
  "customerName": `${userDetails.first_name} ${userDetails.last_name}`,
  "bvn": BVN,
  "nin": NIN,
  "preferredBanks":[bank],
  "getAllAvailableBanks": false
}
};

axios(config)
.then(response => {
  
 if(response.data.responseMessage == 'success'){
 	const acc =response.data.responseBody.accounts[0]
 	
 //console.log(response.data.responseBody.accounts);
 
	let msg ='failed'
	const sql='INSERT INTO `virtual_accounts` (`account_reference`, `providers_account_referrence`, `account_number`,`account_name`,`bank_name`,`fees`,`user_id`) VALUES (?,?,?,?,?,?,?)'

const values =[
	newRefId,
	response.data.responseBody.reservationReference,
	acc.accountNumber,
	acc.accountName,
	acc.bankName,
	finalFee,
	user_id]
	
db.query(sql,values,(err,data)=>{
 if(err){
	res.send(err)
	console.log(err)
	return;
}	
console.log(data)

if(data.affectedRows > 0){
  //console.log('all successfull')
  resolve('all successfull')
  res.end()
  return
}

})

}

}) 
.catch(error => {
	console.log(error.response);
  res.json(error.response)
  return
});	

})

}) 
})
}) 
.then(resp =>{
	console.log(resp)
})
.catch(error => {
	console.log(error)
})
	
}

async function handleCreation(){

await createVa(Sterling)
await createVa(Wema)
}
 handleCreation()
}) })
})
})

router.post('/api/monnify-webhook',(req,res)=>{

//console.log('accessed')	
//res.status(200).send('received')
const obj =req.body.eventData
const {amountPaid,transactionReference} =obj

const referralComm =amountPaid/100*0.5 

if(Object.keys(obj.metaData).length === 0){
	res.send('metadata is empty')
	//console.log('metadata is empty')
	
 const {bankName, accountNumber} = obj.destinationAccountInformation

const feeSql="SELECT * FROM `pricing` WHERE `network`='virtual_accounts'"
	
 db.query(feeSql,(feeErr,feeData)=>{
  if(feeErr){
    console.log(feeErr)
    return
  }
  
 let feeType=feeData[0].type
 let finalFee=parseInt(feeData[0].percent)
// console.log(finalFee)

const sql='SELECT * FROM `virtual_accounts` WHERE `bank_name` = ? AND `account_number` = ?' 
const values =[
	bankName, 
	accountNumber
] 

db.query(sql,values,(err,data)=>{
/*console.log(data.length)
console.log(data)*/

if(err){
	console.log(err)
	//console.log('no virtual account found')
	return
}

if(data.length == 0){
  //console.log('no virtual account found')	
	return
}


if(data.length > 0){
const vaDetails=data[0]
const sql2 ='SELECT * FROM `users` WHERE `id` = ?'
const values2 =[
	vaDetails.user_id
	]

db.query(sql2,values2,(err2,data2)=>{
	if(err2){
		console.log(err2)
		console.log('could not select user_id from users table')
		return
	}

if(data2.length == 0){
	console.log('could not select user_id from users table')
	return
}

//console.log(data2[0])

const userDetails	= data2[0]
const sql3 ='INSERT INTO `deposits`(`user_id`, `amount`, `service_type`, `old_balance`, `new_balance`, `status`, `fees`, `tran_type`, `ref`,`narration`,`username`) VALUES (?,?,?,?,?,?,?,?,?,?,?)'

//const charge = (bankName.includes('Wema') ? 20 : 25);
const charge = finalFee

//const finalAmount =amountPaid > 20 ? (amountPaid - charge) : 0;
let finalAmount=amountPaid > charge ? (amountPaid - charge) : 0; 

if(feeType=='percentage'){
 finalAmount= amountPaid - amountPaid/100*charge;
}
/*else{
 finalAmount =amountPaid > charge ? (amountPaid - charge) : 0; 
}*/

const values3 =[
	userDetails.id,
	finalAmount,
	'Wallet Funding',
	userDetails.balance,
	parseInt(userDetails.balance)+parseInt(finalAmount),
	'success',
  charge,
	'Credit',
	transactionReference,
	`&#8358;${amountPaid} deposited through monnify virtual account with &#8358;${charge} charge. ${bankName} ${accountNumber}`,
	userDetails.username
	]
	
	db.query(sql3,values3,(err3,data3)=>{
		if(err3){
			console.log(err3)
			console.log('deposit record not inserted')
			return
		}
		console.log(data3)
		//console.log('deposit record inserted')
		
	})
	
if(finalAmount < 1){
	console.log('finalAmount is 0')
	return
	}
	
const sql4="UPDATE `users` SET `balance`=`balance`+? WHERE `id`=?"
const values4 =[
	finalAmount,
	userDetails.id
	]
	
	db.query(sql4,values4,(err4,data4)=>{
		if(err){
			console.log(err4)
			console.log('err while updating balance')
			return
		}
		console.log(data4)
		
 if(data4.affectedRows > 0){
	 console.log('balance was updated')
	 const sql5="SELECT * FROM `users` WHERE `id` =?"
	 db.query(sql5,[values4[1]],(err5,data5)=>{
	 	 if(err){
	 	 	console.log(err)
	 	 	return;
	 	 }
	 	 
	 	 if(data5){
	 	 	const referrer=data5[0].referrer_username
	 	 	const sql6="UPDATE `users` SET `balance`=`balance`+?, `referral_comm`=`referral_comm`+? WHERE `username`=?"
	 	 	db.query(sql6,[referralComm,referralComm,referrer],(err6,data6)=>{
	 	 		if(err6){
	 	 			console.log(err6)
	 	 			return;
	 	 		}
	 	 		console.log(data6)
	 	 		if(data6.affectedRows >0){
	 	 			console.log('monnify1 paid referrer')
	 	 			return;
	 	 		}
	 	 		console.log('monnify1 did not pay referrer')
	 	 	})
	 	 }
	 	 
	 })
	 


	 
}
		
		
	})
	
	
})	

	
}
	
})

 
}) 
}
else{
const id = obj.metaData.user_id

const feeSql="SELECT * FROM `pricing` WHERE `network`='monnify_checkout'"
	
 db.query(feeSql,(feeErr,feeData)=>{
  if(feeErr){
    console.log(feeErr)
    return
  }
  
 let finalFee=parseInt(feeData[0].percent)
 let feeType=feeData[0].type

const sql1="SELECT * FROM `users` WHERE `id` =?"

db.query(sql1,[id],(err1,data1)=>{
	if(err1){
		console.log(err1)
		res.send('err while selecting the user')
		res.end()
		console.log('err while selecting the user')
		return
	}
	
	//console.log(data1)
	
	if(!data1[0]){
		console.log('no user found with that id')
		}else{
		console.log('selected user successfully')
		
		const referrer=data1[0].referrer_username
		const oldBal=data1[0].balance
	
		const charge =finalFee;
	//const newBal= (amountPaid > charge ? amountPaid - charge : 0)
	let newBal= (amountPaid > charge ? amountPaid - charge : 0)
	
console.log(newBal)	
		if(feeType=='percentage'){
		  newBal= amountPaid - amountPaid/100*charge;
		}
		/*else{
		 newBal= (amountPaid > charge ? amountPaid - charge : 0)
}*/
		
	  const sql2="INSERT INTO `deposits`(`user_id`, `amount`, `service_type`, `old_balance`, `new_balance`, `status`, `fees`, `tran_type`, `ref`,`narration`,`username`) VALUES (?,?,?,?,?,?,?,?,?,?,?)"	
	 const values2 =[
	 	id,
	 	newBal,
	 	"Wallet Funding",
	 	oldBal,
	 	newBal+oldBal,
	 	"success",
	 	charge,
	 	"Credit",
	 	transactionReference,
	 	`deposit of &#8358;${amountPaid} with &#8358;${charge} fee through monnify`,
	 	data1[0].username
	 	]
		
		db.query(sql2,values2,(err2, data2)=>{
			if(err2){
				console.log(err2)
				console.log('err while inserting deposit record')
				return
			}
			
		if(data2.affectedRows >0){
				console.log('record inserted successfully')
			
			const sql3 ="UPDATE `users` SET `balance`=`balance`+? WHERE `id`=?"
			const values3 =[
				newBal,
				id
				]
			db.query(sql3,values3,(err3,data3)=>{
				if(err3){
					console.log(err3)
					return
				}
				
	 if(data3.affectedRows >0){
			console.log('balance updated')
			res.end()
	   const sql4="UPDATE `users` SET `balance`=`balance`+ ?, `referral_comm`=`referral_comm`+? WHERE `username` =?"
	 	db.query(sql4,[referralComm,referralComm,referrer],(err4,data4)=>{
	 		if(err4){
	 			console.log(err4)
	 			return;
	 		}
	 		console.log(data4)
	 		console.log(referrer)
	 		if(data4.affectedRows >0){
	 			console.log('monnify2 paid the referrer')
	 			return;
	 		}
	 		console.log('monnify did not pay the referrer')
	 	})
	 	
	 }
			
			})
			
			}
			
		})
		
		return
	}
})

})
}


})

router.post('/api/paystack-webhook',(req,res)=>{
let rawAmount=req.body.data.amount/100;

 const feeSql="SELECT * FROM `pricing` WHERE `network`='paystack_checkout'"
	
 db.query(feeSql,(feeErr,feeData)=>{
  if(feeErr){
    console.log(feeErr)
    return
  }
  
 let finalFee=parseInt(feeData[0].percent)
 let feeType=feeData[0].type

let referralComm = rawAmount/100*0.5;

let charge =finalFee
//const total= rawAmount - charge
let total=rawAmount - charge
//console.log(total)
if(feeType=='percentage'){
  total = rawAmount - rawAmount/100*charge
}
/*else{
  total= rawAmount - charge
}*/


//const final = total - charge;

const pkValues =[
	req.body.data.metadata.user_id,
	req.body.data.metadata.charge, 
	req.body.data.metadata.old_balance,
	req.body.data.reference,
  total
	]

 const sql3="SELECT * FROM `users` WHERE `id` =?"
 
 db.query(sql3,[pkValues[0]],(err3,data3)=>{
 	if(err3){
 		console.log(err3)
 		return
 	}
 	 if(data3){
 	   console.log(data3)
 	 	let referrer=data3[0].referrer_username
 	 	
 	 	if(referrer !==''){
 	 	 const sql4="UPDATE `users` SET `balance`=`balance`+ ?,`referral_comm`=`referral_comm`+? WHERE `username` =?"
 	 	 db.query(sql4,[referralComm,referralComm,referrer],(err4,data4)=>{
 	 	 	if(err4){
 	 	 		console.log(err4)
 	 	 		return;
 	 	 	}
 	 	 	//console.log(data4)
 	 	if(data4.affectedRows >0){
 	 		console.log('paid referrer')
 	 	 	/*const sql5="INSERT INTO `referral_commision` (`referrer_username`,`amount`) VALUES()"*/
 	 	 	
 	 	 		return;
 	 	 	}
 	 	 	console.log('did not pay referrer')
 	 	 	
 	 	 })
 	 	}
 	 	
 	 }
	
let sql="INSERT INTO `deposits`(`user_id`, `amount`, `service_type`, `old_balance`, `new_balance`, `status`, `fees`, `tran_type`, `ref`,`narration`,`username`) VALUES (?,?,?,?,?,?,?,?,?,?,?)"

let old_bal= pkValues[2];
let new_bal= parseInt(old_bal)+parseInt(pkValues[4]);
//let fees= pkValues[1];
let fees= charge;

let values =[
	pkValues[0],
	pkValues[4],
	"Wallet Funding",
	old_bal,
	new_bal,
	"success",
	fees,
	"Credit",
	pkValues[3],
	`&#8358;${total} deposit through Paystack`,
	data3[0].username
	]	

let sql2="UPDATE `users` SET `balance`=`balance`+? WHERE `id`=?"
let values2 =[
pkValues[4],
pkValues[0]
	]
	
	db.query(sql,values,(err,data)=>{
		if(err){
			res.send(err)
		return; }
		
	db.query(sql2,values2,(err2,data2)=>{
		if(err2){
			res.send(err2)
		return; }
		
  data2.affectedRows>0 && res.send("balance updated")
  

 	
 	
 })
  
})		
})
})
})

router.post('/api/fund-new-user',(req,res)=> {

let sql="INSERT INTO `deposits`(`user_id`, `amount`, `service_type`, `old_balance`, `new_balance`, `status`, `fees`, `tran_type`, `ref`,`narration`) VALUES (?,?,?,?,?,?,?,?,?,?)"

let values =[
	req.body.id,
	"0.00",
	"Wallet Funding",
	"0.00",
	"0.00",
	"success",
	"0.00",
	"Credit",
	"newusersgift",
	`you have successfully received a new user's funding`
	]	
	
	db.query(sql,values,(err,data)=>{
		if(err){
			res.send(err)
			console.log(err)
			console.log(values)
		  return }
		
	 res.send("transaction recorded")
	})
})

module.exports=router