require('dotenv').config()
const {
	db,
	router,
	extApiUrl,
	extApiKey,
	axios
}=require('../shared.js')

router.post('/api/extApi/sms-name',(req,res)=>{
   const {senderName,id}=req.body

 const hostSql="SELECT * FROM `services_api_keys` WHERE `usage` ='bulk sms'"
  db.query(hostSql,(errH,dataH)=>{
    if(errH){
      console.log(errH)
      return
    }
    const siteHost=dataH[0].site_host
    const siteApiKey=dataH[0].api_key
   
const options = {
  method: 'POST',
  url: `${siteHost}/api/senderid-sms/?sender_id=${senderName}&public_key=${siteApiKey}`,
  headers: {accept: 'application/json'}
};

const sql="INSERT INTO `bulk_sms_usernames` (`user_id`,`name`) VALUES(?,?)"
const values=[id,senderName]

axios
  .request(options)
  .then(response =>{
    console.log(response.data)
    res.send(response.data)
    
    if(response.data.success){
      db.query(sql,values,(err,data)=>{
        if(err){
          console.log(err)
          return;
        }
        console.log(data)
        
      })
    }
    
  })
  .catch(err =>{
    console.error(err)
    res.send(err)
  });
 })   
 })

router.post('/api/extApi/validate_meter',(req,res)=>{
const {disco,meterNumber,meterType}=req.body

 const hostSql="SELECT * FROM `services_api_keys` WHERE `usage` ='electricity'"
  db.query(hostSql,(errH,dataH)=>{
    if(errH){
      console.log(errH)
      return
    }
    const siteHost=dataH[0].site_host
    const siteApiKey=dataH[0].api_key

const options = {
  method: 'POST',
  url: `${siteHost}/api/electricity/verify-merchant/`,
  headers: {accept: 'application/json', 'content-type': 'application/json'},
  data: {
      public_key: siteApiKey,
      service_name: disco,
      meter_type: meterType,
      meter_number: meterNumber
  }
};

axios
  .request(options)
  .then(response => {
    console.log(response.data)
    res.send(response.data)
  })
  .catch(err =>{
    console.error(err)
   res.send('error') 
  });

})
})

router.get('/api/extApi/user/data',(req,res)=>{
  
   const hostSql="SELECT * FROM `services_api_keys` WHERE `usage` ='data'"
  db.query(hostSql,(errH,dataH)=>{
    if(errH){
      console.log(errH)
      return
    }
    const dataSiteHost=dataH[0].site_host
    const dataSiteApiKey=dataH[0].api_key
  
  
  
var config = {
  method: 'get',
maxBodyLength: Infinity,
  url: `${dataSiteHost}/api/user/`,
  headers: { 
    'Authorization': `Token ${dataSiteApiKey}`,
    'Content-Type': 'application/json'
  }
};

axios(config)
.then(function (response) {

res.status(200).json(response.data)

})
.catch(function (error) {
	res.send(error)
  console.log(error);
});

})
})

router.get('/api/extApi/user/exam',(req,res)=>{
  
   const hostSql="SELECT * FROM `services_api_keys` WHERE `usage` ='exam'"
  db.query(hostSql,(errH,dataH)=>{
    if(errH){
      console.log(errH)
      return
    }
    const dataSiteHost=dataH[0].site_host
    const dataSiteApiKey=dataH[0].api_key
  
var config = {
  method: 'get',
maxBodyLength: Infinity,
  url: `${dataSiteHost}/api/user/`,
  headers: { 
    'Authorization': `Token ${dataSiteApiKey}`,
    'Content-Type': 'application/json'
  }
};

axios(config)
.then(function (response) {

res.status(200).json(response.data)

})
.catch(function (error) {
	res.send(error)
  console.log(error);
});

})
})

router.get('/api/extApi/user/cabletv',(req,res)=>{
  
   const hostSql="SELECT * FROM `services_api_keys` WHERE `usage` ='cable sub'"
  db.query(hostSql,(errH,dataH)=>{
    if(errH){
      console.log(errH)
      return
    }
    const dataSiteHost=dataH[0].site_host
    const dataSiteApiKey=dataH[0].api_key
  
var config = {
  method: 'get',
maxBodyLength: Infinity,
  url: `${dataSiteHost}/api/user/`,
  headers: { 
    'Authorization': `Token ${dataSiteApiKey}`,
    'Content-Type': 'application/json'
  }
};

axios(config)
.then(function (response) {

res.status(200).json(response.data)

})
.catch(function (error) {
	res.send(error)
  console.log(error);
});

})
})

router.get('/api/extApi/user/airtime',(req,res)=>{
  
   const hostSql="SELECT * FROM `services_api_keys` WHERE `usage` ='airtime'"
  db.query(hostSql,(errH,dataH)=>{
    if(errH){
      console.log(errH)
      return
    }
    const dataSiteHost=dataH[0].site_host
    const dataSiteApiKey=dataH[0].api_key
  
var config = {
  method: 'get',
maxBodyLength: Infinity,
  url: `${dataSiteHost}/api/user/`,
  headers: { 
    'Authorization': `Token ${dataSiteApiKey}`,
    'Content-Type': 'application/json'
  }
};

axios(config)
.then(function (response) {

res.status(200).json(response.data)

})
.catch(function (error) {
	res.send(error)
  console.log(error);
});

})
})

router.get('/api/api-bal',(req,res)=>{
	
	 const hostSql="SELECT * FROM `services_api_keys` WHERE `usage` ='data'"
  db.query(hostSql,(errH,dataH)=>{
    if(errH){
      console.log(errH)
      return
    }
    const siteHost=dataH[0].site_host
    const siteApiKey=dataH[0].api_key
  
  
	res.json({balance:2000})
	return
var config = {
  method: 'get',
maxBodyLength: Infinity,
  url: `${siteHost}/api/user/`,
  headers: { 
    'Authorization': `Token ${siteApiKey}`,
    'Content-Type': 'application/json'
  }
};

axios(config)
.then(function (response) {
//res.status(200).json(response.data.Dataplans)
	res.status(200).json({
		balance:response.data.user.wallet_balance
})

 console.log(JSON.stringify(response.data.user.wallet_balance));
})
.catch(function (error) {
	res.send(error)
  console.log(error);
});

})
})

router.post('/api/extApi/validate_iuc',(req,res) => {
const values =[
	req.body.iuc,
	req.body.cableName
	]

 const hostSql="SELECT * FROM `services_api_keys` WHERE `usage` ='cable sub'"
  db.query(hostSql,(errH,dataH)=>{
    if(errH){
      console.log(errH)
      return
    }
    const siteHost=dataH[0].site_host
    const siteApiKey=dataH[0].api_key
  
  
var config = {
  method: 'get',
maxBodyLength: Infinity,
  url: `${siteHost}/ajax/validate_iuc?smart_card_number=${values[0]}&cablename=${values[1]}`,
  headers: { 
    'Authorization': `Token ${siteApiKey}`, 
    'Content-Type': 'application/json'
  }
};

axios(config)
.then(function (response) {
 //console.log(JSON.stringify(response.data));
  res.send(JSON.stringify(response.data))
  
})
.catch(function (error) {
  console.log(error);
  res.send(error)
});
})
})

router.get('/api/uzob',(req,res)=>{

var config = {
  method: 'get',
maxBodyLength: Infinity,
  url: 'https://uzobestgsm.com/api/user/',
  headers: {
  	'Authorization': 'Token abdb1ae6a44054889a0219f51b330aef07037d0f' }
};

axios(config)
.then(function (response) {
  console.log(JSON.stringify(response.data));
  res.send(JSON.stringify(response.data));
})
.catch(function (error) {
  console.log(error);
  res.send(error);
});

})

module.exports=router
