require('dotenv').config();

const {
	app,
	express,
	cors,
	cookieParser,
	bodyParser,
  myOrigin,
  axios,
  db,
  generateUniqueId,
  strowalletPK,
  siteUrl,
  siteHost,
  adminUrl
}=require('./src/shared.js')

const userAccess =require('./src/routes/userAccess.js')
const payments =require('./src/routes/payments.js')
const mailSenders =require('./src/routes/mailSenders.js')
const dbQueries =require('./src/routes/dbQueries.js')
const purchaces =require('./src/routes/purchaces.js')
const myApiQueries =require('./src/routes/myApiQueries.js')
const apiQueries =require('./src/routes/apiQueries.js')
const AdminQueries =require('./src/routes/AdminQueries.js')

app.use(
  cors({
    origin:myOrigin,
    methods: ["GET", "POST"],
    credentials: true
  })
); 

app.use(express.json());
app.use(cookieParser());
app.use(bodyParser.urlencoded({extended:true}))
app.use(bodyParser.json());

/*app.use((req, res, next) => {
  const host = req.headers.host;
  //console.log(host)
  if(host!==siteHost && host!=='localhost:8800' && host!==adminUrl.replace('https://','')) {
    return res.status(403).send('Forbidden');
  }
  next();
});*/

const specificRouteMiddleware = (req, res, next) => {
  const host = req.headers.host;
  if (host !== siteHost && host !== 'localhost:8800' && host !== adminUrl.replace('https://', '')) {
    return res.status(403).send('Forbidden');
  }
  next();
}

app.use('/',userAccess)
app.use('/',purchaces)
app.use('/',payments)
app.use('/',apiQueries)
app.use('/',myApiQueries)
app.use('/',mailSenders)
app.use('/',dbQueries)
app.use('/',AdminQueries)

app.get("/api/chad",(req,res)=>{
  res.send('works just fine')
})

process.env.NODE_ENV === 'prod' ?
  app.listen(() => {
    //console.log('App is started without a port');
  })
:
 app.listen(process.env.PORT,()=>{
    console.log(`Server running at http://localhost:${process.env.PORT}/`)
  })
  
function copyMembers(){
  const sql="SELECT * FROM `wpmi_users`"
  db.query(sql,(err,data)=>{
    if(err){
      console.log(err)
      return;
    }
    //console.log(data)
    //return
    
    if(!data){
      console.log('no user found')
      return;
    }
    
  let count=0
    
  data.forEach(user =>{
  console.log(user.user_registered)
  console.log(typeof(user.user_registered))
  const regDate =user.user_registered.toISOString().slice(0,18)
  
      
   const sql2="INSERT INTO `users` (`balance`,`username`,`email`,`first_name`,`last_name`,`phone`,`pwd_hashed`,`password`,`state`,`reg_date`) VALUES (?,?,?,?,?,?,?,?,?,?)"
   const values = [
     0,
     user.user_login,
     user.user_email,
     'Not Set',
     'Not Set',
     '0',
     'Yes',
     user.user_pass,
     'Not Set',
     regDate
     ]
     
 //.replace('.000','') 
 
     db.query(sql2,values,(err2,data2)=>{
       if(err2){
         console.log(err2)
         return;
       }
       
       //do smth
       count++
     })
    })
    
    console.log(count)
    
  })
}


function checkBal(){
  
axios.get('https://api.paystack.co/balance',{
 headers:{
  Authorization: "Bearer sk_live_b19a4b650d26a37f25dcba35adc1de4eb439c40d"
 }
  })
 .then(response =>{
   console.log(response.data)
   console.log(response.data.data[0].balance)
 })
  .catch(err => {
    console.log(err)
  })
}

//checkBal()

function edu(){
  const options = {
  method: 'POST',
  url: 'https://strowallet.com/api/educational/request/',
  headers: {accept: 'application/json', 'content-type': 'application/json'},
  data: {
    service_name: 'waec',
    variation_code: 'waecdirect',
    public_key: 'JCCVO47OXMC6MGUWWOHDS2TU468R1G',
    amount: '1000',
    phone: '07064712617'
  }
};

axios
  .request(options)
  .then(res => console.log(res.data))
  .catch(err => console.error(err));
}

//edu()

async function genAccessToken() {
  try {
    // Fetch API keys from the database
    const apiSql = "SELECT * FROM `gateway_api_keys`";
    const dataSql = await new Promise((resolve, reject) => {
      db.query(apiSql, (errSql, result) => {
        if (errSql) return reject(errSql);
        resolve(result);
      });
    });

    const monnifyKeys = dataSql.find(item => item.name === 'monnify');
    if (!monnifyKeys) throw new Error('Monnify keys not found in the database');

    const base64MonnifyKey = Buffer.from(`${monnifyKeys.public_key}:${monnifyKeys.secret_key}`).toString('base64');

    // Make the Axios request
    const config = {
      method: 'post',
      maxBodyLength: Infinity,
      url: `https://api.monnify.com/api/v1/auth/login`,
      headers: {
        Authorization: `Basic ${base64MonnifyKey}`,
        'Content-Type': 'application/json',
      },
    };

    const res = await axios(config);

    if (res.data.responseMessage === 'success') {
      //console.log('Token generated successfully');
      return res.data.responseBody.accessToken;
    } else {
      throw new Error('Failed to generate token');
    }
  } catch (err) {
    console.error('Error generating token:', err.message);
    return 'err during token gen';
  }
}
//N60
async function verifyNIN (){
//const {user_id} = req.body

//console.log('monnify-va has been accessed')

const genToken =  await genAccessToken()

	//console.log(genToken)
	
	const apiSql="SELECT * FROM `gateway_api_keys`"
		db.query(apiSql,(errSql,dataSql)=>{
		  if(errSql){
		    console.log(errSql)
		    return;
		  }
	 const monnifyKeys=dataSql.filter(item => item.name=='monnify')[0]
		  
var config = {
  method: 'post',
maxBodyLength: Infinity,
  url: `https://api.monnify.com/api/v1/vas/nin-details`,
  headers: { 
    Authorization: `Bearer ${genToken}`,
    'Content-Type': 'application/json'
  },
data:{
  "nin": 14074271255,
}
};

axios(config)
.then(response => {
 console.log(response.data)
})
.catch(error =>{
  console.log(error)
})


})
}

//verifyNIN()

/*data: {
    requestSuccessful: true,
    responseMessage: 'success',
    responseCode: '0',
    responseBody: {
      nin: '14074271255',
      lastName: 'JOHN',
      firstName: 'FAVOUR',
      middleName: 'DANIEL',
      dateOfBirth: '2005-07-02',
      gender: 'MALE',
      mobileNumber: '+2347019380036'
    }
}*/

//N10
async function verifyBVN (){
//const {user_id} = req.body

//console.log('monnify-va has been accessed')

const genToken =  await genAccessToken()

	//console.log(genToken)
	
	const apiSql="SELECT * FROM `gateway_api_keys`"
		db.query(apiSql,(errSql,dataSql)=>{
		  if(errSql){
		    console.log(errSql)
		    return;
		  }
	 const monnifyKeys=dataSql.filter(item => item.name=='monnify')[0]
		  
var config = {
  method: 'post',
maxBodyLength: Infinity,
  url: `https://api.monnify.com/api/v1/vas/bvn-details-match`,
  headers: { 
    Authorization: `Bearer ${genToken}`,
    'Content-Type': 'application/json'
  },
data:{
	"bvn":"22779531154",
    "name": "Favour Daniel John",
    "dateOfBirth": "02-JUL-2005",
    "mobileNo": "07019380036"
}
};

axios(config)
.then(response => {
 console.log(response.data)
})
.catch(error =>{
  console.log(error)
})


})
}

//verifyBVN()

/*{
  requestSuccessful: true,
  responseMessage: 'success',
  responseCode: '0',
  responseBody: {
    bvn: '22779531154',
    name: { matchStatus: 'FULL_MATCH', matchPercentage: 100 },
    dateOfBirth: 'FULL_MATCH',
    mobileNo: 'FULL_MATCH'
  }
}*/

//free
async function verifyBANK (){
//const {user_id} = req.body

//console.log('monnify-va has been accessed')

const genToken =  await genAccessToken()

	//console.log(genToken)
	
	const apiSql="SELECT * FROM `gateway_api_keys`"
		db.query(apiSql,(errSql,dataSql)=>{
		  if(errSql){
		    console.log(errSql)
		    return;
		  }
	 const monnifyKeys=dataSql.filter(item => item.name=='monnify')[0]
		  
var config = {
  method: 'GET',
maxBodyLength: Infinity,
  url: `https://api.monnify.com/api/v1/disbursements/account/validate?accountNumber=7019380036&bankCode=100033`,
  headers: { 
    Authorization: `Bearer ${genToken}`,
    'Content-Type': 'application/json'
  },
data:{
	"bvn":"22779531154",
    "name": "Favour Daniel John",
    "dateOfBirth": "02-JUL-2005",
    "mobileNo": "07019380036"
}
};

axios(config)
.then(response => {
 console.log(response.data)
})
.catch(error =>{
  console.log(error)
})


})
}

//verifyBANK()

/*{
  requestSuccessful: true,
  responseMessage: 'success',
  responseCode: '0',
  responseBody: {
    accountNumber: '7019380036',
    accountName: 'FAVOUR DANIEL JOHN',
    bankCode: '100033'
  }                    
}*/

//N10
async function matchBANKandBVN (){
//const {user_id} = req.body

//console.log('monnify-va has been accessed')

const genToken =  await genAccessToken()

	//console.log(genToken)
	
	const apiSql="SELECT * FROM `gateway_api_keys`"
		db.query(apiSql,(errSql,dataSql)=>{
		  if(errSql){
		    console.log(errSql)
		    return;
		  }
	 const monnifyKeys=dataSql.filter(item => item.name=='monnify')[0]
		  
var config = {
  method: 'post',
maxBodyLength: Infinity,
  url: `https://api.monnify.com/api/v1/vas/bvn-account-match`,
  headers: { 
    Authorization: `Bearer ${genToken}`,
    'Content-Type': 'application/json'
  },
data:{
	"bankCode":"100033",
	"accountNumber":"7019380036",
	"bvn":"22779531154"
}
};

axios(config)
.then(response => {
 console.log(response.data)
})
.catch(error =>{
  console.log(error)
})


})
}

//matchBANKandBVN()

/*{                               requestSuccessful: true,        responseMessage: 'success',
  responseCode: '0',                       responseBody: {                            bvn: '22779531154',
    accountNumber: '7019380036',             accountName: 'FAVOUR DANIEL JOHN',       matchStatus: 'FULL_MATCH',               matchPercentage: 100
  }
}*/


app.get('/api/add-zero-data',(req,res)=>{
  let sql1=`SELECT * FROM purchases WHERE service_type="Data Topup"`
  
  db.query(sql1,(err1,data1)=>{
    if(err1){
      //console.log(err1)
      return;
    }
    
    if(!data1){
      return
    }
    
    //console.log(data1)
    res.send(data1)
//return;

const sql2=`UPDATE purchases SET item_id=? WHERE at=?`

data1.forEach(i =>{
  if(i.item_id.length==11){
    return;
  }
  
db.query(sql2,[0+i.item_id,i.at],(err2,data2)=>{
  if(err2){
    //console.log(err2)
    return
  }
})  
})
//end    

})
})

app.get('/api/add-zero-airtime',(req,res)=>{
  let sql1=`SELECT * FROM purchases WHERE service_type="Airtime VTU"`
  
  db.query(sql1,(err1,data1)=>{
    if(err1){
      //console.log(err1)
      return;
    }
    
    if(!data1){
      return
    }
    
    //console.log(data1)
    res.send(data1)
//return;

const sql2=`UPDATE purchases SET item_id=? WHERE at=?`

data1.forEach(i =>{
  if(i.item_id.length==11){
    return;
  }
  
db.query(sql2,[0+i.item_id,i.at],(err2,data2)=>{
  if(err2){
    //console.log(err2)
    return
  }
})  
})
//end    

})
})





//let subscriptions = [];

app.post("/api/subscribe", (req, res) => {
  const subscription = req.body;
// console.log(subscription)
//subscriptions.push(subscription);

/*console.log(subscription)
console.log(subscriptions)*/

const sql="SELECT * FROM `subscriptions` WHERE `endpoint`=?"

const sql2="INSERT INTO `subscriptions` (`endpoint`,`expirationTime`,`p256dh`,`auth`) VALUES (?,?,?,?)"

const values=[
  subscription.endpoint,
  subscription.expirationTime,
  subscription.keys.p256dh,
  subscription.keys.auth
  ]
  
  db.query(sql,[subscription.endpoint],(err1,data1)=>{
    if(err1){
     return console.log(err1)
    }
    
    if(data1.length>0){
       return res.status(500).json({status: "you have an existing subscription"})
    }
    
  db.query(sql2,values,(err2,data2)=>{
    if(err2){
      console.log(err2)
      return
    }
    
    if(data2.affectedRows==0){
      return res.status(500).json({status: "failed to insert subscription into db"});
    }
    res.status(201).json({status: "successfully inserted subscription into db"});
    
  })
  
  })  
});

/*app.post("/api/send-notification",specificRouteMiddleware, (req, res) => {

let subscriptions=[] 
 
const {title,body}=req.body
    
const sql="SELECT * FROM `subscriptions`"

  db.query(sql,(err,data)=>{
    if(err){
     return console.log(err)
    }
    
    if(data.length==0){
      return res.status(200).json({ message: "No user has subscribed to your notifications yet" })
    }

   data.forEach(i =>{
     subscriptions.push({
       "endpoint":i.endpoint,
       "expirationTime":i.expirationTime,
       keys:{
         "p256dh":i.p256dh,
         "auth":i.auth
       }
     })
   }) 
  
  if(subscriptions.length==0){
     console.log('did not send push notification')
    return res.send('did not send push notification')
  }
  
  console.log(subscriptions)
  
  const notificationPayload = {
      title,
      body,
      icon: `${siteUrl}/logo_original.png`,
      data: {
        url: `${siteUrl}/dashboard`,
      },
  };

  Promise.all(
  subscriptions.map((subscription)=>{
  webpush.sendNotification(subscription, JSON.stringify(notificationPayload))
})
    
)
  .then(() => {
      res.status(200).json({ message: "Notification sent successfully." })
      // res.json(subscriptions)
    })
    .catch((err) => {
      console.error("Error sending notification");
      res.sendStatus(500);
    })
  
 })  
});*/

