import { EmailParams } from "../models";
import { RequestService, APIResponse } from "../services/request.service";
import { ActivityModule } from "./email/Activity.module";
import { AnalyticsModule } from "./email/Analytics.module";
import { DomainModule } from "./email/Domain.module";
import { InboundModule } from "./email/Inbound.module";
import { MessageModule } from "./email/Message.module";
import { ScheduleModule } from "./email/Schedule.module";
import { RecipientModule } from "./email/Recipient.module";
import { TemplateModule } from "./email/Template.module";
import { EmailWebhookModule } from "./email/Webhook.module";
import { IdentityModule } from "./email/Identity.module";
export declare class EmailModule extends RequestService {
    activity: ActivityModule;
    analytics: AnalyticsModule;
    domain: DomainModule;
    inbound: InboundModule;
    message: MessageModule;
    schedule: ScheduleModule;
    recipient: RecipientModule;
    template: TemplateModule;
    webhook: EmailWebhookModule;
    identity: IdentityModule;
    constructor(apiKey: string, baseUrl: string);
    send(params: EmailParams): Promise<APIResponse>;
    sendBulk(params: EmailParams[]): Promise<APIResponse>;
    getBulkStatus(bulkId: string): Promise<APIResponse>;
}
export interface Personalization {
    email: string;
    data: {
        [key: string]: any;
    };
}
