require('dotenv').config()
const {
	db,
	session,
	router,
	generateUniqueId,
	hashAndVerify,
	GetCurrentFormattedTime
}=require('../shared.js')

function generateResetCode(length) {
  let code="";
  const theArray = Array.from({ length }, () => Math.floor(Math.random() * 10));
  
  theArray.forEach(num => {
    code+=num;
  });
  return code;
}

router.post('/api/airtime-pins-records',(req,res)=>{
	
 const {
 	user_id,
 	limit,
 	start_date,
 	end_date,
 	network
 }=req.body;
 
 let sql=`SELECT * FROM airtime_pins WHERE user_id=? ${start_date && start_date == end_date && 'AND DATE(`date`)=?'} ${start_date && start_date !== end_date && 'AND date BETWEEN ? AND ?'} ${network !=='All' && 'AND network=?'} ORDER BY date DESC ${limit !== 'All' && 'limit ?'}`
 
 sql=sql.replaceAll('undefined','')
 sql=sql.replaceAll('false','')
	//${network !=='' && 'AND network=?'}
	
 let values=[
 	user_id,
 	start_date && start_date,
 	start_date && start_date !== end_date && end_date,
  network!=='All' && network,
 	limit 
 	
 	]
 	
 //values.shift(undefined)
  
 values = values.filter(item => item !== undefined);
 values = values.filter(item => item !== false);
 values = values.filter(item => item !== '');

 db.query(sql,values,(err,data)=>{
		if(err){
			console.log(err)
			res.send(err)
			console.log(values);
			return;
		}
		
		if(data.length > 0){
			//console.log(data)
		  res.send(data)	
		  return
		}
		console.log('no rows found')
		res.send('no rows found')
	})
	
})

router.post('/api/get-referrals',(req,res)=>{
	const {username}=req.body;
	const sql="SELECT * FROM `referrals` WHERE `referrer_username` =?"
	db.query(sql,[username],(err,data)=>{
		if(err){
			console.log(err)
			return
		}
		res.send(data)
	})
})

router.post('/api/get-va',(req,res)=>{
const {id} =req.body

let sql= "SELECT * FROM `virtual_accounts` WHERE `user_id`=? "
	db.query(sql,[id],(err,data)=>{
		if(err){
			res.send(err)
			console.log(err)
		}
		
		if(data.length >0){
		res.send(data)
		//console.log(data)
		return
		}
		res.send('no va found')
		//console.log('no va found')
	})
})

router.get('/api/notice',(req,res)=>{
	let sql= "SELECT * FROM `notice` WHERE `display`= 'true' "

 db.query(sql,(err,data) => {
 	if(err){
 		res.send("error occurred while fetching notice")
 		console.log('error occurred while fetching notice')
  	return; 
}

 	data.length >0 ? res.send(data[0].message) : res.send('empty')
})
})

router.get('/api/gains',(req,res)=>{
const sql='SELECT * FROM `pricing` '

db.query(sql, (err,data) => {

 if(err){
 	console.log(err)
 	res.send(err)
 	return
 }
 
 res.send(data)

})
})

router.post('/api/get-transactions',(req,res)=>{
let id=req.body.id

let sql= 'SELECT user_id, amount AS amount, item_id AS item_id, reference as ref, NULL AS narration, NULL AS fees, NULL AS from_account_num, NULL AS from_account_name, status AS status, tran_type AS tran_type, new_balance AS new_bal, service_type AS service_type, truth_res AS truth_res, description AS description, old_balance AS old_balance, created_at FROM purchases WHERE user_id = ? UNION ALL SELECT  user_id, amount AS deposit_amount,  NULL AS item_id, ref AS ref, narration AS narration, fees AS fees, from_account_num AS from_account_num, from_account_name AS from_account_name, status AS status, tran_type AS tran_type, NULL AS new_bal, service_type AS service_type, NULL AS truth_res, NULL AS description, NULL AS old_balance, created_at FROM deposits WHERE user_id = ? ORDER BY created_at DESC';

	db.query(sql,[id,id],(err,data)=>{
		if(err){
			res.send(err)
			console.log(err)
			return;
		}
		res.send(data)
	})	
})

router.post('/api/get-transaction-by-ref',(req,res)=>{
	
	let values=[
		req.body.ref,
		req.body.id
		]
		
let sql= "SELECT * FROM `purchases` WHERE `reference`=? AND `user_id`=? ";
	db.query(sql,[values[0],values[1]],(err,data)=>{
		if(err){
  	res.json({
		purchase:0,
	   error:err})
	   
	console.log(JSON.stringify({
		purchase:0,
	   error:err}))
	   return;
		}
		
			if(data.length>0){
	res.json({
		purchase:data,
	   error:0})
			}
			else{
let sql2 ="SELECT * FROM `deposits` WHERE `ref`=? AND `user_id`=? ";

db.query(sql2,[values[0],values[1]],(error,data2)=>{
if(error){
	res.json({
		deposit:0,
	   error:error})
	   
	console.log(JSON.stringify({
		deposit:0,
	   error:error}))
	
}else{
	//res.send(data2)
	if(data2.length>0){
	res.json({
		deposit:data2,
	   error:0})
	}else{
	res.json({
	   msg:"no data found"})
	console.log(JSON.stringify({
	   msg:`no data found. ${req.body.id}`}))	
	}
}
})
}
})	
})

router.post('/api/share-funds',(req,res) => {
const senderUsername =req.body.sender

let sql8 ="SELECT * FROM `users` WHERE `username` =?"
db.query(sql8,senderUsername,(err8,data8)=>{if(err8){
	console.log(err8)
}else{
	var oldBal=data8[0].balance
	
if(oldBal>=req.body.amount){
const amount=req.body.amount;
const receiverUsername =req.body.receiver

const values =[
senderUsername,
receiverUsername,
amount
]

const sql=`UPDATE users 
SET balance = CASE WHEN username ='${values[0]}' THEN balance - '${values[2]}' WHEN username ='${values[1]}' THEN balance + '${values[2]}' END WHERE username IN ('${values[0]}','${values[1]}')
`

const sql2 = `SELECT id, balance
FROM users
WHERE username = '${values[0]}'

UNION ALL

SELECT id, balance
FROM users
WHERE username = '${values[1]}'`
	
	db.query(sql,(err,data) => {if(err){
		res.send(err)
		console.log(err)
	}else{
		res.send(data)
		
		if(data.affectedRows>1){
			db.query(sql2,(err2,data2) => {
				if(err2){
					console.log(err2)
					//res.send(err2)
				}else{
			     //res.send(data2)
if(data2.length>1){
const senderOldBal =data2[0].balance			     
const senderId =data2[0].id	
const receiverOldBal =data2[1].balance
const receiverId =data2[1].id	

let sql="SELECT * FROM `purchases`"
let takenIds=[];
let newRefId;
	db.query(sql,(err,data3)=>{
		if(err){
			res.send(err)
			console.log(err)
		}else{
		//	console.log(data3)
		data3.forEach(item => {
			takenIds.push(item.reference)
		})
	
newRefId=generateUniqueId(30,takenIds)

const values4a =[
	senderId,
	amount,
	"Shared Funds",
	senderOldBal,
	senderOldBal - amount,
	"success",
	"0.00",
	"Debit",
	`shared${newRefId}`,
	`you transferred ${amount} to user ${receiverUsername}`
	]	

const sql4="INSERT INTO `deposits`(`user_id`, `amount`, `service_type`, `old_balance`, `new_balance`, `status`, `fees`, `tran_type`, `ref`,`narration`) VALUES (?) , (?)"

const values4b =[
	receiverId,
	amount,
	"Received Funds",
	receiverOldBal,
	parseInt(receiverOldBal) + parseInt(amount),
	"success",
	"0.00",
	"Credit",
	`received${newRefId}`,
	`user ${senderUsername} transferred ${amount} to you`
	]	

db.query(sql4,[values4a,values4b], (err4,data4) => {
	if(err4){
		console.log(err4)
	}
	else{
		/*console.log(data4)
		console.log(receiverUsername)*/
	}
})

}
})

}else{
	console.log("could'nt select data of both users")
}
				}
			})
		}
	}
		
	})
	
}else{
	res.send("insufficient balance")
	console.log("insufficient balance")
}	}})
	
})

router.post('/api/get-similar-usernames',(req,res) => {
const username=req.body.username	
	const sql =`SELECT username,id FROM users WHERE MATCH (username) AGAINST ('${username}*' IN BOOLEAN MODE) ORDER BY username LIMIT 6`
	
	db.query(sql,username,(err,data) => {if(err){
		res.send(err)
		console.log(err)
	}else{
		res.send(data)
	
	}
		
	})
})

router.post('/api/insert-resetcode',(req,res) => {
//const resetCode= req.body.resetcode
	const values =[
	req.body.resetCode,
	req.body.email
]
	
	const sql="UPDATE `users` SET `resetcode` = ? WHERE `email`= ?"
	
	db.query(sql,values,(err,data) => {
		if(err){
			res.send(err)
			console.log(err)
		}else{
			if(data.affectedRows>0){
			//res.send(data)
			res.send(data)
			console.log(data)
			console.log("inserted resetcode")
			}else{
				
				console.log("could'nt insert resetcode")
				console.log(values)
				res.send("could'nt insert resetcode")
			}
		}
	})
	
})

router.post('/api/reset-password',(req,res) => {
	const pwd_last_reset_time=req.body.pwd_last_reset_time
	
	const values=[
		hashAndVerify(req.body.password),
		GetCurrentFormattedTime(),
		req.body.resetCode
		]
	
	const sql="UPDATE `users` SET `password` = ?,`pwd_last_reset_time`=? WHERE `resetcode`= ?"

db.query(sql,values,(err,data) => {
if(err){
	res.send(err)
	console.log(err)
		}else{
		res.send(data)
		}
	})
})

router.post('/api/get-email',(req,res) => {
	const email= req.body.email
	let resetCode=generateResetCode(6)
	
	const sql="SELECT * FROM `users` WHERE `email` = ?"
	
	db.query(sql,email,(err,data) => {
		if(err){
			res.send(err)
			console.log(err)
		}else{
			if(data.length>0){
let myObj=data[0].newResetCode=resetCode
			res.send(data)
		}else{
			res.send({data:"user not found"})
		}
		}
	})
})

router.post('/api/get-user-details',(req,res)=>{
let sql="SELECT * FROM `users` WHERE `id` =?"

db.query(sql,[req.body.id],(err,data)=>{
	if(err){
		res.send(err)
		console.log(err)
		return
	}
	
	
	const dataObj=data
	 delete dataObj[0].password
	 delete dataObj[0].resetcode
	
	res.send(dataObj)
	
})
})

router.post('/api/update-profile',(req,res)=>{

const {
	id,
	user,
	firstname,
	lastname,
	email,
	phone,
}=req.body
	
let sql="UPDATE `users` SET `username`=?,`first_name`=?, `last_name`=?, `email`=?, `phone`=? WHERE `id`=?"	
let csql="SELECT * FROM `users` WHERE `id` =?"
db.query(csql,[id],(err,data)=>{
	if(err){
		res.send(err)
		console.log(err)
		return
	}
	//console.log(data)
	/*if(data.length>0){
		res.send("username already taken")
		return
		}*/
	
db.query(sql,[
	user,
	firstname,
	lastname,
	email,
	phone,
	id
	],(err2,data2)=>{
		if(err2){
			res.send(err2)
			console.log(err2)
			return;
		}
		  //console.log(data2)
			res.send(data2)
		
	});
			
})

})

router.post('/api/get-purchase-by-phone',(req,res)=>{
	let sql="SELECT * FROM `purchases` WHERE `reference` = ?"
	
	db.query(sql,req.body.phone,(err,data)=>{
	if(err){
		res.send(err)
		console.log(err)
	}
	else{
	res.send(data)	
	
	}
	})
})

router.post('/api/change-password',(req,res)=>{
	
	const {
		id,
		oldPwd,
		newPwd
	}=req.body
		
let sql= "SELECT * FROM `users` WHERE `id`=?";
	db.query(sql,[id,oldPwd],(err,data)=>{
		if(err){
			res.send(err)
			console.log(err)
			return
		}

	/*if(data.length < 1){
		res.send("incorrect password")
		return
	}*/
	
	const existingPwd=data[0].password
	console.log(newPwd)
	if(!hashAndVerify(oldPwd,existingPwd)){
		res.send("incorrect password")
		console.log('incorrect password')
		return
	}
	
	const hashedPwd=hashAndVerify(newPwd)
	
	let sql2="UPDATE `users` SET `password` =? WHERE `id` =?"
	db.query(sql2,[hashedPwd,id],(err2,data2)=>{
  if(err2){
	  res.send(err2)
    console.log(err2)
   	return
 }
  
   console.log(data2)
 
	  if(data2.affectedRows >0){
	  	res.send('update successful')
	  	console.log('update success')
	  	return;
	  }	
	  res.send('update failed')
	  console.log('update failed')
})

})	
	
})

module.exports=router