require('dotenv').config()
const {
	db,
	router,
	extApiUrl,
	extApiKey,
	axios
}=require('../shared.js')

router.get('/api/extApi/user',(req,res)=>{
var config = {
  method: 'get',
maxBodyLength: Infinity,
  url: `${extApiUrl}/api/user/`,
  headers: { 
    'Authorization': `Token ${extApiKey}`,
    'Content-Type': 'application/json'
  }
};

axios(config)
.then(function (response) {

function updatePlanAmounts(obj) {
  Object.keys(obj).forEach(key => {
    // Check if the key contains "go" (case-insensitive) for GOTV
    if (key.toLowerCase().includes("go")) {
      obj[key].forEach(item => {
        item.plan_amount = (parseFloat(item.plan_amount) * 1.02).toFixed(2); // Apply 2% increase for GOTV
      });
      console.log('it had go')
    }
    
    // Check if the key contains "dstv" (case-insensitive) for DSTV
    if (key.toLowerCase().includes("dstv")) {
      obj[key].forEach(item => {
        item.plan_amount = (parseFloat(item.plan_amount) * 1.0104).toFixed(2); // Apply 1.04% increase for DSTV
      });
    }

    // Check if the key contains "star" (case-insensitive) for STARTIMES
    if (key.toLowerCase().includes("star")) {
      obj[key].forEach(item => {
        item.plan_amount = (parseFloat(item.plan_amount) * 1.05).toFixed(2); // Example: Apply 5% increase for STARTIMES
      });
    }
  });
}

let theObj=response.data

updatePlanAmounts(theObj)
//console.log(response.data)

res.status(200).json(response.data)

})
.catch(function (error) {
	res.send(error)
  console.log(error);
});

})

router.get('/api/api-bal',(req,res)=>{
	
	res.json({balance:2000})
	return
var config = {
  method: 'get',
maxBodyLength: Infinity,
  url: `${extApiUrl}/api/user/`,
  headers: { 
    'Authorization': `Token ${extApiKey}`,
    'Content-Type': 'application/json'
  }
};

axios(config)
.then(function (response) {
//res.status(200).json(response.data.Dataplans)
	res.status(200).json({
		balance:response.data.user.wallet_balance
})

 console.log(JSON.stringify(response.data.user.wallet_balance));
})
.catch(function (error) {
	res.send(error)
  console.log(error);
});

})

router.post('/api/extApi/validate_iuc',(req,res) => {
const values =[
	req.body.iuc,
	req.body.cableName
	]

var config = {
  method: 'get',
maxBodyLength: Infinity,
  url: `${extApiUrl}/ajax/validate_iuc?smart_card_number=${values[0]}&cablename=${values[1]}`,
  headers: { 
    'Authorization': `Token ${extApiKey}`, 
    'Content-Type': 'application/json'
  }
};

axios(config)
.then(function (response) {
 //console.log(JSON.stringify(response.data));
  res.send(JSON.stringify(response.data))
  
})
.catch(function (error) {
  console.log(error);
  res.send(error)
});
})

router.get('/api/uzob',(req,res)=>{

var config = {
  method: 'get',
maxBodyLength: Infinity,
  url: 'https://uzobestgsm.com/api/user/',
  headers: {
  	'Authorization': 'Token abdb1ae6a44054889a0219f51b330aef07037d0f' }
};

axios(config)
.then(function (response) {
  console.log(JSON.stringify(response.data));
  res.send(JSON.stringify(response.data));
})
.catch(function (error) {
  console.log(error);
  res.send(error);
});

})

module.exports=router
