require('dotenv').config()
const {
	db,
	router,
	extApiUrl,
	extApiKey,
	axios,
	transporter,
	session,
	sessionStore,
	generateUniqueId,
	hashAndVerify,
	smtpUser,
	siteHost
}=require('../shared.js')

//console.log(hashAndVerify('$Sp88006363_secret_SECURE'))
//console.log(hashAndVerify('88006363.Sp'))

router.post('/api/admin/records/cash',(req,res)=>{
	
 const {
 	period,
 	start_date,
 	end_date,
 	column
 }=req.body;
 
 let sql=`SELECT SUM(${column}) AS ${column} FROM purchases ${period && period !=='all time' && `${start_date && start_date == end_date && 'WHERE DATE(`created_at`)=?'}${start_date && start_date !== end_date && 'WHERE created_at BETWEEN ? AND ?'}`} ORDER BY created_at DESC`
 
 // SELECT SUM(`amount`) FROM `purchases` WHERE DATE(`created_at`)='2024-10-21';
 
 sql=sql.replaceAll('undefined','')
 sql=sql.replaceAll('false','')
	//${network !=='' && 'AND network=?'}
	
 let values=[
 	start_date && start_date,
 	start_date && start_date !== end_date && end_date
 	]
 	
 //values.shift(undefined)
  
 values = values.filter(item => item !== undefined);
 values = values.filter(item => item !== false);
 values = values.filter(item => item !== '');

console.log(values)
console.log(sql)

 db.query(sql,values,(err,data)=>{
		if(err){
			console.log(err)
			res.send(err)
			return;
		}
		
	 if(data.length < 1){
      console.log('no rows found')
	  	res.send('no rows found')
		  return
		}
		
		console.log(data)
		console.log(data[0][column])
		  res.send(data[0])	
		
	})
	
})

router.post('/api/admin/user/delete',(req,res)=>{
const {user}=req.body

const sql ='DELETE FROM `users` WHERE `username` =?'
	
 db.query(sql,[user],(err,data)=>{
 	if(err){
		res.send(err)
		console.log(err)
		return
	}
	 if(data.affectedRows >0){
			res.send('deleted user')
       console.log('deleted user')
  		return
		}
		console.log('no user found')
		res.send('no user found')
	})
})

router.get('/api/admin/info',(req,res)=>{

const sql ='SELECT * FROM `admin` WHERE `id` =1'
	
 db.query(sql,(err,data)=>{
 	if(err){
		res.send(err)
		console.log(err)
	}else{
		//res.send(data[0])
	const{first_name,last_name,}=data[0]
	
		res.json({
			first_name,
			last_name
		})
	}
		
	})
})

router.get('/api/admin/transactions/feed/:limit',(req,res)=>{
const {limit}=req.params

let sql= 'SELECT user_id, amount AS amount, item_id AS item_id, reference as ref, NULL AS narration, NULL AS fees, NULL AS from_account_num, NULL AS from_account_name, status AS status, tran_type AS tran_type, new_balance AS new_bal, service_type AS service_type, truth_res AS truth_res, description AS description, old_balance AS old_balance, created_at FROM purchases UNION ALL SELECT user_id, amount AS deposit_amount,  NULL AS item_id, ref AS ref, narration AS narration, fees AS fees, from_account_num AS from_account_num, from_account_name AS from_account_name, status AS status, tran_type AS tran_type, NULL AS new_bal, service_type AS service_type, NULL AS truth_res, NULL AS description, NULL AS old_balance, created_at FROM deposits ORDER BY created_at DESC LIMIT ?';

	db.query(sql,[parseInt(limit)],(err,data)=>{
		if(err){
			res.send(err)
			console.log(err)
			return;
		}
		res.send(data)
	})	
})

router.post('/api/admin/users/similar/username',(req,res) => {
const {username,limit}=req.body

const sql =`SELECT * FROM users WHERE MATCH (username) AGAINST ('${username}*' IN BOOLEAN MODE) ORDER BY reg_date desc LIMIT ?`
	
 db.query(sql,[parseInt(limit)],(err,data) => {if(err){
		res.send(err)
		console.log(err)
	}else{
		res.send(data)
	}
		
	})
})

router.get('/api/admin/gains',(req,res)=>{
const sql="SELECT SUM(`gain`) AS `totalGain` FROM `purchases`"	
	
		db.query(sql,(err,data)=>{
		if(err){
			console.log(err)
			return;
		}
		console.log(data[0])
		if(data){
			res.send(data[0])
		}
	})
	
})

router.get('/api/admin/users/count',(req,res)=>{
const sql="SELECT count(*) AS `usersCount` FROM `users`"	
	db.query(sql,(err,data)=>{
		if(err){
			console.log(err)
			return;
		}
	if(data){
		res.send(data[0])
		}
	})
	
})

router.get('/api/admin/activity/:limit',(req,res)=>{
	const {limit}=req.params
	
const sql="SELECT * FROM `admin_activity` ORDER BY `date` DESC LIMIT ?"	

db.query(sql,[parseInt(limit)],(err,data)=>{
		if(err){
			console.log(err)
			return;
		}
 
		if(data){
			res.send(data)
		}
	})
	
})

router.post('/api/admin/activity',(req,res)=>{
	const {point,message}=req.body
	
const sql="INSERT INTO `admin_activity` (`point`,`message`) VALUES(?,?)"	

db.query(sql,[point,message],(err,data)=>{
		if(err){
			console.log(err)
			res.send(err)
			return;
		}
 
		if(data.affectedRows >0 ){
			res.send('activity recorded')
			console.log('activity recorded')
		}
	})
	
})

router.get('/api/admin/purchaces/:limit',(req,res)=>{
const {limit}=req.params

const sql="SELECT * FROM `purchases` ORDER BY `created_at` desc LIMIT ?"	
 
 db.query(sql,[parseInt(limit)],(err,data)=>{
		if(err){
			console.log(err)
			return;
		}
		
		if(data){
			res.send(data)
			
			let myArray=0;
		data.forEach(item =>{
		myArray+=1	
		
		})
		
		}
	})
	
})

router.get('/api/admin/allpurchaces',(req,res)=>{

const sql="SELECT * FROM `purchases` ORDER BY `created_at`"	
 
 db.query(sql,(err,data)=>{
		if(err){
			console.log(err)
			return;
		}
		
		if(data){
			res.send(data)
			
			let myArray=0;
		data.forEach(item =>{
		myArray+=1	
		
		})
		
		}
	})
	
})

router.get('/api/admin/deposits/:limit',(req,res)=>{
const {limit}=req.params

const sql="SELECT * FROM `deposits` ORDER BY `created_at` desc LIMIT ?"	

db.query(sql,[parseInt(limit)],(err,data)=>{
		if(err){
			console.log(err)
			return;
		}
		console.log(data)
		if(data){
			res.send(data)
		}
	})
	
})

router.get('/api/admin/mail/get',(req,res)=>{
	
	
})

router.post('/api/admin/mail/send',(req,res)=>{
	
const {subject,message,to}=req.body

async function sendMail(){
	
 let mailOptions = {
    from: `"${siteHost}" <${smtpUser}>`,
    to: to,
    subject: subject,
    text: `ignored text field`,
    html:`
<div style='margin:20px auto; text-align:center'>
<p>
${message}
</p>
</div>`,
  };

  try {
    let info = await transporter.sendMail(mailOptions);
    if(info.messageId){
    	res.send('mail sent')
    	return;
    }
    res.send('mail not sent')
  } catch (error) {
  	res.send('mail send error')
    console.error('Error sending email:', error);
  }
}

sendMail()
})

router.get('/api/admin/apidetails',(req,res)=>{
	
	/*res.json({
	user:{
  	wallet_balance:2100
	}
})
	return*/
	
var config = {
  method: 'get',
maxBodyLength: Infinity,
  url: `${extApiUrl}/api/user/`,
  headers: { 
    'Authorization': `Token ${extApiKey}`,
    'Content-Type': 'application/json'
  }
};

axios(config)
.then(function (response) {
	
	res.status(200).send(response.data)
})
.catch(function (error) {
	
	res.json({
	user:{
  	wallet_balance:"fetch err"
	}
})
	
  console.log(error);
});

})

router.get('/api/admin/notice/get',(req,res)=>{
const sql="SELECT * FROM `notice` WHERE `id`= 1"
	db.query(sql,(err,data)=>{
		if(err){
			console.log(err)
			return;
		}
		
		res.send(data)
	})
	
})

router.post('/api/admin/notice/change',(req,res)=>{
	const {message}=req.body 
	
const sql="UPDATE `notice` SET `message`=? WHERE `id`= 1"
	db.query(sql,[message],(err,data)=>{
		if(err){
			console.log(err)
			return;
		}
	
		data.affectedRows > 0 && res.send('notice updated')
	})
	
})

router.post('/api/admin/pricings',(req,res)=>{
	const {network,percent}=req.body
	const sql="UPDATE `pricing` SET `percent`= ? WHERE `network` =?"
	
	db.query(sql,[percent,network],(err,data)=>{
		if(err){
			console.log(err)
			return;
		}
		console.log(data)
		if(data.affectedRows >0){ 
			res.send('price updated')
			console.log('price updated')
			return
		}
		console.log('price not updated')
		res.send('not updated')
	})
	
})

router.get('/api/admin/pricings',(req,res)=>{
	const sql="SELECT * FROM `pricing` "
	db.query(sql,(err,data)=>{
		if(err){
			console.log(err)
			return
		}
		res.send(data)
		console.log(data)
	})
})

router.post('/api/admin/login',(req,res)=>{
	const {pwd}=req.body
	
	const sql="SELECT * FROM `admin` WHERE `id`=1"
 db.query(sql,(err,data)=>{
		if(err){
			console.log(err)
			return
		}
		
	if(data.length >0){
		const currentPwd=data[0].password
		
		if(hashAndVerify(pwd,currentPwd)){
		req.session.username=data[0].first_name
			res.send('login success')
			console.log('login success')
			return;
	}
		
		console.log('wrong password')
		res.send('wrong password')
		
	}	
	})
})

router.get("/api/admin/isLoggedIn",(req,res)=>{
	
 if(req.session.username){
    res.json({
      isLoggedIn: true,
      username: req.session.username
    });
 } else{
  res.json({ isLoggedIn: false });
 }
 
})

router.get('/api/admin/logout', (req,res)=>{
	
  req.session.destroy(err =>{
   res.clearCookie(process.env.SESSION_NAME)
   res.send('logged out')
 })
 
})

router.post('/api/admin/password/change',(req,res)=>{
	const {secret,newPwd}=req.body;
	const hashedPwd =hashAndVerify(newPwd)
	const sql="SELECT `secret` FROM `admin` WHERE `id`=1"
	const sql2="UPDATE `admin` SET `password` = ? WHERE `id`=1"
	db.query(sql,(err,data)=>{
		if(err){
			console.log(err)
			return;
		}
		
		const currentSecret=data[0].secret
	
	 if(!hashAndVerify(secret,currentSecret)){
			res.send('invalid secret')
		 console.log('invalid secret')
		 return
		}
		
		db.query(sql2,[hashedPwd,secret],(err2,data2)=>{
			if(err){
				console.log(err2)
				return
			}
		console.log(data2)
			if(data2.affectedRows >0){
				res.send('password updated')
				console.log('password updated')
		    return;
			}
			
			console.log('password update failed')
			res.send('password update failed')
		})
		
	})
	
})

router.post('/api/admin/user/get',(req,res)=>{
	const {username}=req.body;
	const sql="SELECT * FROM `users` WHERE `username` =?"
	db.query(sql,[username],(err,data)=>{
		if(err){
			console.log(err)
			return;
		}
		
		if(data.length >0){
			res.send(data)
			return;
		}
		res.send('no user found')
	})
})

router.get('/api/admin/user/getall/:limit',(req,res)=>{
	
	const {limit}=req.params
	
	const sql="SELECT * FROM `users` ORDER BY `reg_date` desc LIMIT ?  "
	db.query(sql,[parseInt(limit)],(err,data)=>{
		if(err){
			console.log(err)
			return;
		}
	
		if(data.length >0){
			res.send(data)
			return;
		}
		res.send('no users found')
	})
})

router.post('/api/admin/user/update',(req,res)=>{
	const {
		newUsername,
		firstname,
		lastname,
		username,
		status,
		password,
		email
	}=req.body;
	const sql="UPDATE `users` SET `first_name`=?, `last_name`=?, `username`=?, `status`=?, `password`=?, `email`=? WHERE `username` =?"
	const values=[
		firstname,
		lastname,
		newUsername,
		status,
		hashAndVerify(password),
		email,
		username
		]
		
	db.query(sql,values,(err,data)=>{
		if(err){
			console.log(err)
			if(err.sqlMessage.includes(`username`)){
				res.send('username is taken')
			}else if(err.sqlMessage.includes(`email`)){
				res.send('email is taken')
			}
			return
		}
		
		if(data.affectedRows >0){
			res.send('update success')
	    return;
		}
		res.send("update failed")
	})
	
})

router.post('/api/admin/user/credit',(req,res)=>{
	const {username,amount}=req.body
  console.log(username,amount)
	const sql="UPDATE `users` SET `balance`=`balance`+? WHERE `username`= ?"
	db.query(sql,[amount,username],(err,data)=>{
		if(err){
			console.log(err)
			return;
		}
		
		if(data.affectedRows >0){
			console.log('user credited')
		  res.send('user credited')
		
		const sql2="SELECT * FROM `users` WHERE `username` =?"
		  db.query(sql2,[username],(err2,data2)=>{
		  	if(err2){
		  		console.log(err2)
		  		return;
		  	}
		  	
		  if(!data2){
		  	console.log('no user found')
		  	
		  	return;
		  }
		  	
let sql4="SELECT * FROM `purchases`"
let takenIds=[];
let newRefId;
	db.query(sql4,(err4,data4)=>{
		if(err4){
			res.send(err4)
			console.log(err4)
			return;
	}
		
data4.forEach(item => {
			takenIds.push(item.reference)
		})

newRefId=generateUniqueId(30,takenIds)
		  	
		  	const user=data2[0]
		  	const oldBal=parseInt(user.balance - amount)
		  	
		  	let sql3="INSERT INTO `deposits`(`user_id`, `amount`, `service_type`, `old_balance`, `new_balance`, `status`, `fees`, `tran_type`, `ref`,`narration`) VALUES (?,?,?,?,?,?,?,?,?,?)"

				let values3 =[
					user.id,
					amount,
					"Wallet Funding",
					oldBal,
					oldBal+parseInt(amount),
					"success",
					"0.00",
					"Credit",
					newRefId,
					`you have received a manual funding of &#8358;${amount} initiated by the admin`
					]
					
				db.query(sql3,values3,(err3,data3)=>{
					if(err3){
						console.log(err3)
						return
					}
					
				if(data3.affectedRows >0){
						console.log('credit record inserted')
						
						return;
					}
					console.log('credit record NOT inserted')
					
					
				})	
	})			
		  	
		  })
		
			return;
		}
		res.send('invalid user')
	})
})

router.post('/api/admin/user/debit',(req,res)=>{
	const {username,amount}=req.body
	const sql="UPDATE `users` SET `balance`=`balance`-? WHERE `username`= ?"
	db.query(sql,[amount,username],(err,data)=>{
		if(err){
			console.log(err)
			return;
		}
		
		if(data.affectedRows >0){
			console.log('user debited')
		  res.send('user debited')
		  
		  const sql2="SELECT * FROM `users` WHERE `username` =?"
		  db.query(sql2,[username],(err2,data2)=>{
		  	if(err2){
		  		console.log(err2)
		  		return;
		  	}
		  	
		  if(!data2){
		  	console.log('no user found')
		  	
		  	return;
		  }
		  	
let sql4="SELECT * FROM `purchases`"
let takenIds=[];
let newRefId;
	db.query(sql4,(err4,data4)=>{
		if(err4){
			res.send(err4)
			console.log(err4)
			return;
	}
		
data4.forEach(item => {
			takenIds.push(item.reference)
		})

newRefId=generateUniqueId(30,takenIds)
		  	
		  	const user=data2[0]
		  	const oldBal=user.balance + parseInt(amount)
		  	
		  	let sql3="INSERT INTO `deposits`(`user_id`, `amount`, `service_type`, `old_balance`, `new_balance`, `status`, `fees`, `tran_type`, `ref`,`narration`) VALUES (?,?,?,?,?,?,?,?,?,?)"

				let values3 =[
					user.id,
					amount,
					"Wallet Debit",
					oldBal,
					oldBal - parseInt(amount),
					"success",
					"0.00",
					"Debit",
					newRefId,
					`you have received a debit of &#8358;${amount} initiated by the admin`
					]
					
				db.query(sql3,values3,(err3,data3)=>{
					if(err3){
						console.log(err3)
						return
					}
					
				if(data3.affectedRows >0){
						console.log('debit record inserted')
						
						return;
					}
					console.log('debit record NOT inserted')
					
					
				})	
	})			
		  	
		  })
		  
			return;
		}
		
   	res.send('invalid user')
	})
})

module.exports=router