require('dotenv').config();

const {
	app,
	express,
	cors,
	cookieParser,
	bodyParser,
  myOrigin,
  axios
}=require('./src/shared.js')

const userAccess =require('./src/routes/userAccess.js')
const payments =require('./src/routes/payments.js')
const mailSenders =require('./src/routes/mailSenders.js')
const dbQueries =require('./src/routes/dbQueries.js')
const purchaces =require('./src/routes/purchaces.js')
const myApiQueries =require('./src/routes/myApiQueries.js')
const apiQueries =require('./src/routes/apiQueries.js')
const AdminQueries =require('./src/routes/AdminQueries.js')

app.use(
  cors({
    origin:myOrigin,
    methods: ["GET", "POST"],
    credentials: true
  })
); 

app.use(express.json());
app.use(cookieParser());
app.use(bodyParser.urlencoded({extended:true}))
app.use(bodyParser.json());
 
app.use('/',userAccess)
app.use('/',purchaces)
app.use('/',payments)
app.use('/',apiQueries)
app.use('/',myApiQueries)
app.use('/',mailSenders)
app.use('/',dbQueries)
app.use('/',AdminQueries)

process.env.NODE_ENV === 'prod' ?
  app.listen(() => {
    console.log('App is started without a port');
  })
:
 app.listen(process.env.PORT, () => {
    console.log(`Server running at http://localhost:${process.env.PORT}/`)
  })



const apiKey='MK_PROD_6AH0SDZMRG'
const secretKey='QM9HVP41FCQG1DRQWJLQ66719F6ARVPF'

const base64MonnifyKey = Buffer.from(`${apiKey}:${secretKey}`).toString('base64');

 async function genAccessToken(){
 let accessToken;	
 
 var config = {
  method: 'post',
maxBodyLength: Infinity,
  url: `https://api.monnify.com/api/v1/auth/login`,
  headers: { 
    Authorization: `Basic ${base64MonnifyKey}`,
    'Content-Type': 'application/json'
  }
};

 await axios(config)
.then(res => {
	//console.log(res.data);
	
if(res.data.responseMessage=='success'){
  accessToken = res.data.responseBody.accessToken
  console.log('token gen success')
  return
}
  accessToken = 'err '
})
.catch(err => {
  //console.error(err);
  //console.error('err during token gen');
  accessToken = 'err during token gen'
});

 return accessToken
}

const successObj={
  "requestSuccessful": true,
  "responseMessage": "success",
  "responseCode": "0",
  "responseBody": {
    "contractCode": "650923896591",
    "accountReference": "swbbift123",
    "accountName": "Oto",
    "currencyCode": "NGN",
    "customerEmail": "favourdanieljohn@gmail.com",
    "customerName": "Otobong Ini",
    "accounts": [
      {
        "bankCode": "232",
        "bankName": "Sterling bank",
        "accountNumber": "5177322505",
        "accountName": "Oto"
      },
      {
        "bankCode": "035",
        "bankName": "Wema bank",
        "accountNumber": "6761086231",
        "accountName": "Oto"
      }
    ],
    "collectionChannel": "RESERVED_ACCOUNT",
    "reservationReference": "102MQDTYSHQCF6A05894",
    "reservedAccountType": "GENERAL",
    "status": "ACTIVE",
    "createdOn": "2024-09-22 19:38:03.015",
    "incomeSplitConfig": [],
    "bvn": "22779531154",
    "nin": "14074271255",
    "restrictPaymentSource": false
  }
}

app.get('/api/test-monnify2', async(req,res)=>{
	
let genToken = await genAccessToken()
	//console.log(genToken)
	
if(genToken.includes('err')){
	console.log(genToken)
	res.send(genToken)
	return
}
	const paga ="327",
	      wema ='035',
	      sterling ='232',
	      access ='044',
	      firstBank ='011',
	      smartCash ='00803'
	      
//const preferredBank =req.query.bank	      

var config = {
  method: 'post',
maxBodyLength: Infinity,
  url: `https://api.monnify.com/api/v2/bank-transfer/reserved-accounts`,
  headers: { 
    Authorization: `Bearer ${genToken}`,
    'Content-Type': 'application/json'
  },
  data:{ 
  	"accountReference": "svftas1vg2bbh3",
    "accountName": "Otobong Friday",
    "currencyCode": "NGN",
    "contractCode": "650923896591",
    "customerEmail": "favourdanieljohn@gmail.com",
    "customerName": "Otobong",
    "bvn": "22779531154",
    "nin":"14074271255",
    "preferredBanks":[
    	`${wema}`,
    	`${sterling}`,
   ],
    "getAllAvailableBanks": false
  }
};

axios(config)
.then(response => {
  console.log(response.data);
  res.json(response.data)
  
  if(response.data.responseCode == 0){
  response.data.responseBody.accounts.forEach(acc =>{
	console.log(`${acc.bankName} : ${acc.accountNumber}`)
	
 })
}
  
})
.catch(error => {
  console.log(error.response.data);
  res.json(error.response.data)
});	
	
})



