"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequestService = void 0;
var gaxios_1 = require("gaxios");
var qs = require('qs');
var RequestService = /** @class */ (function () {
    function RequestService(apiKey, baseUrl) {
        this.apiKey = apiKey;
        this.baseUrl = baseUrl;
    }
    RequestService.prototype.post = function (path, data) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.request("POST", path, data)];
            });
        });
    };
    RequestService.prototype.get = function (path, queryParams) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.request("GET", path, null, queryParams)];
            });
        });
    };
    RequestService.prototype.deleteReq = function (path, data) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.request("DELETE", path, data)];
            });
        });
    };
    RequestService.prototype.put = function (path, data) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.request("PUT", path, data)];
            });
        });
    };
    RequestService.prototype.request = function (method, path, body, queryParams) {
        return __awaiter(this, void 0, void 0, function () {
            var requestParams, _a, headers, data, status_1, e_1, _b, headers, data, status_2;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _c.trys.push([0, 2, , 3]);
                        requestParams = {
                            url: path,
                            baseURL: this.baseUrl,
                            method: method,
                            headers: { Authorization: "Bearer ".concat(this.apiKey) },
                            responseType: "json",
                        };
                        if (body) {
                            requestParams.data = body;
                        }
                        if (queryParams) {
                            requestParams.params = queryParams;
                            requestParams.paramsSerializer = function (params) {
                                return qs.stringify(params);
                            };
                        }
                        return [4 /*yield*/, (0, gaxios_1.request)(requestParams)];
                    case 1:
                        _a = _c.sent(), headers = _a.headers, data = _a.data, status_1 = _a.status;
                        return [2 /*return*/, { headers: headers, body: data, statusCode: status_1 }];
                    case 2:
                        e_1 = _c.sent();
                        if (e_1 === null || e_1 === void 0 ? void 0 : e_1.response) {
                            _b = e_1.response, headers = _b.headers, data = _b.data, status_2 = _b.status;
                            throw { headers: headers, body: data, statusCode: status_2 };
                        }
                        else {
                            throw e_1;
                        }
                        return [3 /*break*/, 3];
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    return RequestService;
}());
exports.RequestService = RequestService;
