"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailWebhookEventType = exports.EmailWebhook = void 0;
var EmailWebhook = /** @class */ (function () {
    function EmailWebhook(config) {
        if (config) {
            this.url = config.url;
            this.name = config.name;
            this.events = config.events;
            this.domain_id = config.domain_id;
            this.enabled = config.enabled;
        }
    }
    EmailWebhook.prototype.setUrl = function (url) {
        this.url = url;
        return this;
    };
    EmailWebhook.prototype.setName = function (name) {
        this.name = name;
        return this;
    };
    EmailWebhook.prototype.setEvents = function (events) {
        this.events = events;
        return this;
    };
    /**
     * Set domain id
     * @param domainId - Existing hashed domain ID.
     */
    EmailWebhook.prototype.setDomainId = function (domainId) {
        this.domain_id = domainId;
        return this;
    };
    EmailWebhook.prototype.setEnabled = function (enabled) {
        this.enabled = enabled;
        return this;
    };
    return EmailWebhook;
}());
exports.EmailWebhook = EmailWebhook;
var EmailWebhookEventType;
(function (EmailWebhookEventType) {
    EmailWebhookEventType["SENT"] = "activity.sent";
    EmailWebhookEventType["DELIVERED"] = "activity.delivered";
    EmailWebhookEventType["SOFT_BOUNCED"] = "activity.soft_bounced";
    EmailWebhookEventType["HARD_BOUNCED"] = "activity.hard_bounced";
    EmailWebhookEventType["OPENED"] = "activity.opened";
    EmailWebhookEventType["CLICKED"] = "activity.clicked";
    EmailWebhookEventType["UNSUBSCRIBED"] = "activity.unsubscribed";
    EmailWebhookEventType["SPAM_COMPLIANT"] = "activity.spam_complaint";
})(EmailWebhookEventType = exports.EmailWebhookEventType || (exports.EmailWebhookEventType = {}));
