export declare class EmailWebhook {
    url: string;
    name: string;
    events: EmailWebhookEventType[];
    domain_id: string;
    enabled?: boolean;
    constructor(config?: IEmailWebhook);
    setUrl(url: string): EmailWebhook;
    setName(name: string): EmailWebhook;
    setEvents(events: any[]): EmailWebhook;
    /**
     * Set domain id
     * @param domainId - Existing hashed domain ID.
     */
    setDomainId(domainId: string): EmailWebhook;
    setEnabled(enabled: boolean): EmailWebhook;
}
export declare enum EmailWebhookEventType {
    SENT = "activity.sent",
    DELIVERED = "activity.delivered",
    SOFT_BOUNCED = "activity.soft_bounced",
    HARD_BOUNCED = "activity.hard_bounced",
    OPENED = "activity.opened",
    CLICKED = "activity.clicked",
    UNSUBSCRIBED = "activity.unsubscribed",
    SPAM_COMPLIANT = "activity.spam_complaint"
}
export interface IEmailWebhook extends IEmailWebhookUpdate {
    domain_id: string;
}
export interface IEmailWebhookUpdate {
    url: string;
    name: string;
    events: EmailWebhookEventType[];
    enabled?: boolean;
}
