"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailParams = void 0;
var EmailParams = /** @class */ (function () {
    function EmailParams(config) {
        this.from = config === null || config === void 0 ? void 0 : config.from;
        this.to = config === null || config === void 0 ? void 0 : config.to;
        this.cc = config === null || config === void 0 ? void 0 : config.cc;
        this.bcc = config === null || config === void 0 ? void 0 : config.bcc;
        this.reply_to = config === null || config === void 0 ? void 0 : config.replyTo;
        this.in_reply_to = config === null || config === void 0 ? void 0 : config.inReplyTo;
        this.subject = config === null || config === void 0 ? void 0 : config.subject;
        this.text = config === null || config === void 0 ? void 0 : config.text;
        this.html = config === null || config === void 0 ? void 0 : config.html;
        this.send_at = config === null || config === void 0 ? void 0 : config.sendAt;
        this.attachments = config === null || config === void 0 ? void 0 : config.attachments;
        this.template_id = config === null || config === void 0 ? void 0 : config.templateId;
        this.tags = config === null || config === void 0 ? void 0 : config.tags;
        this.variables = config === null || config === void 0 ? void 0 : config.variables;
        this.personalization = config === null || config === void 0 ? void 0 : config.personalization;
        this.precedence_bulk = config === null || config === void 0 ? void 0 : config.precedenceBulk;
    }
    EmailParams.prototype.setFrom = function (from) {
        this.from = from;
        return this;
    };
    EmailParams.prototype.setTo = function (to) {
        this.to = to;
        return this;
    };
    EmailParams.prototype.setCc = function (cc) {
        this.cc = cc;
        return this;
    };
    EmailParams.prototype.setBcc = function (bcc) {
        this.bcc = bcc;
        return this;
    };
    EmailParams.prototype.setReplyTo = function (replyTo) {
        this.reply_to = replyTo;
        return this;
    };
    EmailParams.prototype.setInReplyTo = function (inReplyTo) {
        this.in_reply_to = inReplyTo;
        return this;
    };
    EmailParams.prototype.setSubject = function (subject) {
        this.subject = subject;
        return this;
    };
    EmailParams.prototype.setText = function (text) {
        this.text = text;
        return this;
    };
    EmailParams.prototype.setHtml = function (html) {
        this.html = html;
        return this;
    };
    EmailParams.prototype.setSendAt = function (sendAt) {
        this.send_at = sendAt;
        return this;
    };
    EmailParams.prototype.setAttachments = function (attachments) {
        this.attachments = attachments;
        return this;
    };
    EmailParams.prototype.setTemplateId = function (id) {
        this.template_id = id;
        return this;
    };
    EmailParams.prototype.setTags = function (tags) {
        this.tags = tags;
        return this;
    };
    EmailParams.prototype.setVariables = function (variables) {
        this.variables = variables;
        return this;
    };
    EmailParams.prototype.setPersonalization = function (personalization) {
        this.personalization = personalization;
        return this;
    };
    EmailParams.prototype.setPrecedenceBulk = function (precedenceBulk) {
        this.precedence_bulk = precedenceBulk;
        return this;
    };
    EmailParams.prototype.setSettings = function (settings) {
        this.settings = settings;
        return this;
    };
    return EmailParams;
}());
exports.EmailParams = EmailParams;
