const crypto=require('crypto')

require('dotenv').config()

const mysql = require("mysql"),
session = require("express-session"),
MySQLStore = require("express-mysql-session")(session), 
nodemailer = require('nodemailer'),
axios = require("axios"),
cors = require("cors"),
cookieParser = require("cookie-parser"),
bodyParser = require("body-parser"),
express = require("express"),
extApiKey=process.env.EXT_API_KEY,
extApiUrl=process.env.EXT_API_URL,
generateUniqueId=require('./utilities/UniqueBankIdGenerator.js'),
monnifyApiKey=process.env.MONNIFY_API_KEY,
monnifySecretKey=process.env.MONNIFY_SECRET_KEY,
smtpUser=process.env.SMTP_USER,
smtpHost=process.env.SMTP_HOST,
siteUrl=process.env.SITE_URL,
siteHost=process.env.SITE_HOST,
adminUrl=process.env.ADMIN_URL,
strowalletPK=process.env.STROWALLET_PK,
strowalletEnv=process.env.STROWALLET_ENV,
monnifyContractCode=process.env.MONNIFY_CONTRACT_CODE,
BVN=process.env.BVN,
NIN=process.env.NIN

const app = express();
const router = express.Router()

let myOrigin;
process.env.NODE_ENV === 'dev' ?
myOrigin="http://localhost:5173"
:
myOrigin=[siteUrl,adminUrl]

const dbOptions = {
  host: process.env.DB_HOST,
  user: process.env.DB_USER,
  password: process.env.DB_PASSWORD,
  database: process.env.DB_NAME,
  waitForConnections: true,
  connectionLimit: 10,
  queueLimit: 0
};

const db = mysql.createPool(dbOptions);

db.on('connection',(connection)=>{
  console.log('db conn used!');
  connection.on('error', (err)=>{
  console.error('db conn error:', err);
  });
});

const transporter = nodemailer.createTransport({
  host: process.env.SMTP_HOST,
  port: process.env.SMTP_PORT,
  secure: true,
  auth: {
    user: process.env.SMTP_USER,
    pass: process.env.SMTP_PASS,
  },
});

const sessionStore = new MySQLStore(dbOptions);

app.use(session({
    name:process.env.SESSION_NAME,
    resave: false,
    saveUninitialized: false,
    store: sessionStore,
    secret: process.env.SESSION_SECRET,
    cookie: {
        httpOnly: true,
        maxAge: 1000*60*60*168,
        sameSite: true,
        secure: false
    }
}))

function hashAndVerify(pwd, storedHash = null) {
 const hash = crypto.createHash('sha256')  
 
 .update(pwd) 
 .digest('hex');
 
 if (!storedHash){
    return hash;
  }

   return hash === storedHash;
}

function GetCurrentFormattedTime(){
  const date = new Date();
  return date.toISOString().replace('T', ' ').slice(0, 19);
}

module.exports ={
 app,
 express,
 router,
 axios,
 cors,
 cookieParser,
 bodyParser,
 extApiUrl,
 extApiKey,
 db,
 session,
 MySQLStore,
 sessionStore,
 dbOptions,
 transporter,
 nodemailer,
 generateUniqueId,
 myOrigin,
 hashAndVerify,
 monnifyApiKey,
 monnifySecretKey,
 smtpUser,
 smtpHost,
 siteUrl,
 siteHost,
 adminUrl,
 GetCurrentFormattedTime,
 strowalletPK,
 strowalletEnv,
 monnifyContractCode,
 BVN,
 NIN
}