require('dotenv').config();

const {
	app,
	express,
	cors,
	cookieParser,
	bodyParser,
  myOrigin,
  axios,
  db,
  generateUniqueId,
  strowalletPK,
  siteUrl,
  siteHost,
  adminUrl
}=require('./src/shared.js')

const userAccess =require('./src/routes/userAccess.js')
const payments =require('./src/routes/payments.js')
const mailSenders =require('./src/routes/mailSenders.js')
const dbQueries =require('./src/routes/dbQueries.js')
const purchaces =require('./src/routes/purchaces.js')
const myApiQueries =require('./src/routes/myApiQueries.js')
const apiQueries =require('./src/routes/apiQueries.js')
const AdminQueries =require('./src/routes/AdminQueries.js')

app.use(
  cors({
    origin:myOrigin,
    methods: ["GET", "POST"],
    credentials: true
  })
); 

app.use(express.json());
app.use(cookieParser());
app.use(bodyParser.urlencoded({extended:true}))
app.use(bodyParser.json());

/*app.use((req, res, next) => {
  const host = req.headers.host;
  //console.log(host)
  if(host!==siteHost && host!=='localhost:8800' && host!==adminUrl.replace('https://','')) {
    return res.status(403).send('Forbidden');
  }
  next();
});*/

app.use('/',userAccess)
app.use('/',purchaces)
app.use('/',payments)
app.use('/',apiQueries)
app.use('/',myApiQueries)
app.use('/',mailSenders)
app.use('/',dbQueries)
app.use('/',AdminQueries)

app.get("/api/chad",(req,res)=>{
  res.send('works just fine')
})

process.env.NODE_ENV === 'prod' ?
  app.listen(() => {
    console.log('App is started without a port');
  })
:
 app.listen(process.env.PORT,()=>{
    console.log(`Server running at http://localhost:${process.env.PORT}/`)
  })
  

var config = {
  method: 'get',
maxBodyLength: Infinity,
  url: 'https://datastation.com.ng/ajax/validate_meter_number?meternumber=meternumber&disconame=disconame&mtype=metertype',
  headers: { 
    'Authorization': 'Token 66f2e5c39ac8640f13cd888f161385b12f7e5e92', 
    'Content-Type': 'application/json'
  }
};

axios(config)
.then(function (response) {
  console.log(JSON.stringify(response.data));
})
.catch(function (error) {
  console.log(error);
});
